# Money Management Package 

This package adds price and currency functionality to

## Installation

You can install the package via composer:

```bash
composer require mtcmedia/money
```

## Usage

This package allows managing price display and tax conversions on prices.
This allows storing single price value + its tax rate rather than storing 
individual inc-vat ex-vat values in DB.
``` php
$price = new Price($amount, $rate = 'Standard')
```
Price object offers a number of actions for output:
```twig
{{ price }} - displays formatted content
{{ price.raw }} - returns raw output value
{{ price.tax }} - returns tax on price value
{{ price.withTax }} - returns price including tax
{{ price.withoutTax }} - returns price excluding tax
```

## Configuration
This package offers a number of configuration values.
To change these you will need to publish the config if you don't see `tax.php` in `/config/*`
```bash
php artisan vendor:publish --class=Mtc\Money\Providers\MoneyServiceProvider
```

Once this is done you can edit the tax.php file to configure price display.

### Testing

This package has test coverage. Tests are required to be run when
making changes to this package. If new functionality has been added
new tests need to be written.
``` bash
phpunit vendor/mtcmedia/money/tests/**
```

### Changelog

Please see [CHANGELOG](CHANGELOG.md) for more information what has changed recently.
