<?php

namespace Mtc\Orders\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Mtc\Orders\Contracts\OrderContract;
use Mtc\Orders\Order;

/**
 * Class OrderStatusChangeController
 *
 * @package Mtc\Orders
 */
class OrderStatusChangeController extends Controller
{
    /**
     * Update order status
     *
     * @param Request $request
     * @param $id
     * @param OrderContract $order
     * @return \Illuminate\Http\RedirectResponse
     */
    public function __invoke(Request $request, $id, $status_id, OrderContract $order)
    {
        $request->merge([
            'status_id' => $status_id
        ]);

        $this->validate($request, [
            'status_id' => 'required|numeric|exists:order_statuses,id',
        ]);

        /** @var Order $order */
        $order = $order->find($id);
        $order->changeStatus($request->input('status_id'), Auth::user());
        return redirect()->back();
    }
}
