<?php

namespace Mtc\Notifications\Facades;

use Illuminate\Contracts\Auth\Authenticatable;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Support\Facades\Facade;
use Mtc\Notifications\Contracts\NotificationModel;

/**
 * Class Media
 *
 * Media class Facade
 *
 * @method static bool   hasUnread(Authenticatable $user)
 * @method static Collection getAll(Authenticatable $user, $per_page = null, int $page = null)
 * @method static void markRead(NotificationModel $notification, Authenticatable $user)
 * @method static void markUnread(NotificationModel $notification, Authenticatable $user)
 * @method static NotificationModel addNotification($severity, $message, $details, $required_permission, $source)
 * @method static bool destroy($notification_ids)
 *
 */
class Notification extends Facade
{
    /**
     * Define the facade accessor
     *
     * @return string
     */
    protected static function getFacadeAccessor()
    {
        return 'notification_repository';
    }
}
