<?php

namespace Mtc\Notifications\Tests\Unit;

use Illuminate\Contracts\Validation\Factory;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Foundation\Testing\WithFaker;
use Mtc\Notifications\Contracts\NotificationModel;
use Mtc\Notifications\Tests\TestCase;

class NotificationModelTest extends TestCase
{

    public function test_view_url_attribute(): void
    {
        $model = $this->model();
        $model->id = 1;

        self::assertStringContainsString('1', $model->getViewUrlAttribute());

        /** @var \Illuminate\Contracts\Validation\Factory $validator */
        $validator = app(Factory::class);
        $wrong_url = $validator->make([
            'url' => $model->getViewUrlAttribute()
        ], [
            'url' => 'url'
        ])->fails();

        self::assertFalse($wrong_url);

    }

    private function model(): NotificationModel
    {
        return app(NotificationModel::class);
    }

}
