<?php
/**
 * @author Aleksey Lavrinenko
 * @version 28.02.2016.
 */
namespace MtcMedia\Mvc;

use Illuminate\Container\Container;
use Illuminate\Support\Fluent;
use MtcMedia\SimpleView\SimpleView;

abstract class Controller extends \Illuminate\Routing\Controller
{
    /**
     * @var Container
     */
    protected $app;

    /**
     * @var SimpleView|\Twig_Environment
     */
    protected $view;

    public function __construct()
    {
        $this->app = App::getFacadeRoot();
    }

    public function header()
    {
        return '';
    }

    public function footer()
    {
        return '';
    }

    protected function getControllerName()
    {
        $controller = preg_replace('#^.*\\\([a-zA-Z0-9]+)Controller$#', '$1', get_class($this));
        return strtolower($controller);
    }

    public function wrapHtmlResponse($content)
    {
        return $this->header()
        . $content
        . $this->footer();
    }

    public function errepStop()
    {
        if (DEV_MODE) {
            \Debug\Errep::stop();
        }
    }

    public function errepStart()
    {
        if (DEV_MODE) {
            \Debug\Errep::start();
        }
    }

    public function render($template, $context = [])
    {
        return $this->wrapHtmlResponse(
            $this->view->render($template, $context)
        );
    }

    public function es6JsonResponse($data)
    {
        return new Fluent([
            'data' => $data,
        ]);
    }

    /**
     * @return Fluent
     */
    public function readRawPostAsJson()
    {
        $data = $this->readRawPost();
        $data = json_decode($data);
        return new Fluent($data);
    }

    /**
     * @return string
     */
    protected function readRawPost()
    {
        $data = file_get_contents('php://input');
        return $data;
    }
}
