<?php
/**
 * @author Aleksey Lavrinenko
 * @version 28.02.2016.
 */
namespace MtcMedia\Mvc;

use Illuminate\Container\Container;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Request;
use MtcMedia\SimpleView\SimpleView;
use Okneloper\Session\Session;

abstract class AdminController extends Controller
{
    /**
     * @var \MtcMedia\SimpleView\SimpleView
     */
    protected $view;

    /**
     * @var Container
     */
    protected $app;

    /**
     * Additional header filename (no extension)
     * @var string
     */
    protected $header = SITE_PATH . '/core/admin/templates/admin-sub-header.phtml';

    /**
     * Additional footer filename (no extension)
     * @var string
     */
    protected $footer;

    /**
     * Module folder name
     * @var string
     */
    protected $module;

    /**
     * Templates path
     * @var string
     */
    protected $templates_path;

    /**
     * Root folder (from document root)
     * @var string
     */
    protected $root;

    protected $tabs = [
        'Manage' => '/',
    ];

    protected $tab_active = 0;

    public function __construct()
    {
        parent::__construct();

        if (isset($this->app['module_root'])) {
            $this->root = str_replace(SITE_PATH, '', $this->app['module_root']);
            $this->module = basename($this->root);
        }

        // try to detect module name automagically. This is assuming the controller file is in the
        // /admin/{module}/controllers folder
        if (!$this->module) {
            $class_info = new \ReflectionClass($this);
            $this->module = basename(dirname(dirname($class_info->getFileName())));
            #$this->module = $this->getControllerName();
        }

        if (!$this->templates_path) {
            $this->templates_path = SITE_PATH . "{$this->root}/templates";
        }

        $view = new SimpleView($this->templates_path);

        $view->addGlobal('root', $this->root);
        $view->addGlobal('module', $this->module);
        $view->addGlobal('request', Request::getFacadeRoot());

        $this->view = $view;
    }

    /**
     * @return int
     */
    protected function adminUserId()
    {
        return $GLOBALS['adminuser']->get_details('id');
    }

    public function header()
    {
        if (!isset($page)) {}

        $header = '';
        $header .= $this->view->render(SITE_PATH . '/core/admin/templates/adminheader.html.php');
        if ($this->header) {
            $header .= $this->view->render($this->header);
        }
        return $header;
    }

    public function footer()
    {
        $footer = '';
        if ($this->footer) {
            $footer .= $this->view->render($this->footer);
        }
        $footer .= $this->view->render(SITE_PATH .'/core/admin/templates/adminfooter.html.php');
        return $footer;
    }

    public function render($template, $context = [])
    {
        $this->view->addGlobal('tabs', $this->tabs);
        $this->view->addGlobal('tab_active', $this->tab_active);

        return parent::render($template, $context);
    }

    /**
     * Set title of the page for <h1> and meta tags
     * @param $title
     */
    protected function setPageTitle($title)
    {
        $this->view->addGlobal('meta_title', $title);
    }

    public function addEdit($object)
    {
        return $object->id > 0 ? 'Edit' : 'Add';
    }

    public function addTab($name, $href = null)
    {
        $this->tabs[$name] = $href;
        $this->tab_active = count($this->tabs) - 1;
    }

    /**
     * @return Session
     */
    public function session()
    {
        return new Session("admin/" . $this->module);
    }
}
