<?php

namespace MtcMedia\Mvc;

/**
 * Created 02/08/2018
 * @author Aleksey Lavrinenko <aleksey.lavrinenko@mtcmedia.co.uk>
 */
class RequestInterceptor
{
    /**
     * @var RoutingComponent
     */
    protected $routing;

    /**
     * RequestInterceptor constructor.
     * @param RoutingComponent $routing
     */
    public function __construct(RoutingComponent $routing)
    {
        $this->routing = $routing;
    }

    public function intercepted()
    {
        try {
            // make sure exception is not hidden so that we can catch it
            $this->routing->setHideLiveException(false);
            $this->routing->handleRequest();
            return true;
        } catch (\Symfony\Component\HttpKernel\Exception\NotFoundHttpException $exception) {
            return false;
        }
    }
}
