<?php

namespace Mtc\MultiBuy\Validators;

use Mtc\MultiBuy\Discount;

/**
 * Class DiscountableItem
 * @package Mtc\MultiBuy\Validators
 */
class DiscountableItem
{
    /**
     * @param Discount $discount
     * @param $item
     * @return bool
     */
    public function validate(Discount $discount, $item): bool
    {
        if ((int)$discount->sale_restriction === Discount::ALL_ITEMS) {
            return true;
        }

        if ($discount->sale_restriction === Discount::NON_SALE_ITEMS && !$item->purchasable->hasDiscountedPrice()) {
            return true;
        }

        if ($discount->sale_restriction === Discount::ONLY_SALE_ITEMS && $item->purchasable->hasDiscountedPrice()) {
            return true;
        }

        return false;
    }
}
