<?php

namespace Mtc\MultiBuy\Providers;

use Illuminate\Foundation\Support\Providers\EventServiceProvider;
use Mtc\Basket\Http\Resources\BasketAjax;
use Mtc\Basket\Http\Resources\CheckoutAjax;
use Mtc\MultiBuy\Listeners\SetBasketDiscount;
use Mtc\MultiBuy\Listeners\SetCheckoutDiscount;

/**
 * Class DiscountEventServiceProvider
 * @package Mtc\MultiBuy\Providers
 */
class DiscountEventServiceProvider extends EventServiceProvider
{
    /**
     * The event handler mappings for the application.
     *
     * @var array
     */
    protected $listen = [
        BasketAjax::class => [
            SetBasketDiscount::class,
        ],
        CheckoutAjax::class => [
            SetCheckoutDiscount::class
        ]
    ];
}
