<?php

namespace Mtc\MultiBuy\Contracts;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Collection;
use Mtc\MultiBuy\Charts\Discount as DiscountChart;

/**
 * Interface DiscountRepositoryInterface
 * @package Mtc\MultiBuy\Contracts
 */
interface DiscountRepositoryInterface
{
    /**
     * Get Discount Class
     *
     * @return Model
     */
    public function getDiscountClass();

    /**
     * Find a discount by id
     *
     * @param int $id
     */
    public function findById(int $id);

    /**
     * Set discount model
     *
     * @param $coupon
     */
    public function setModel($discount);

    /**
     * Get discount ID
     *
     * @return integer|null
     */
    public function getId();

    /**
     * Fetch the current discount model
     *
     * @return mixed
     */
    public function getModel();

    /**
     * Get Discount Types
     *
     * @return Collection
     */
    public function getTypes(): Collection;

    /**
     * Get all available discount restrictions
     *
     * @return Collection
     */
    public function getRestrictions(): Collection;

    /**
     * Get Basic restrictions
     *
     * @return Collection
     */
    public function getBasicRestrictions(): Collection;

    /**
     * Get Sale restrictions
     *
     * @return Collection
     */
    public function getSaleRestrictions(): Collection;

    /**
     * Get Discounts
     *
     * @param bool $paginate
     * @return mixed
     */
    public function getDiscounts(bool $paginate = true);

    /**
     * Get discount usage chart
     *
     * @return DiscountChart|null
     */
    public function getChart();

    /**
     * Update or Create Model from request
     *
     * @param $request
     * @param null $id
     */
    public function updateOrCreateModel($request, $id = null);

    /**
     * Delete Model by Id
     *
     * @param $id
     */
    public function deleteById($id);
}
