<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

/**
 * Class RemoveUnusedColumnsFromDiscountsTable
 */
class RemoveUnusedColumnsFromDiscountsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('discounts', function (Blueprint $table) {
            $table->dropColumn('min_basket_price');
            $table->dropColumn('only_first_purchase');
            $table->dropColumn('allstock');
            $table->dropColumn('members_only');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('discounts', function (Blueprint $table) {
            $table->decimal('min_basket_price', 10)->nullable()->index();
            $table->boolean('only_first_purchase')->default(0);
            $table->boolean('allstock')->default(0);
            $table->boolean('members_only')->nullable();
        });
    }
}
