<?php

namespace Mtc\MultiBuy;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\MorphTo;

/**
 * Class Restriction
 * @package Mtc\MultiBuy
 */
class Restriction extends Model
{
    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'discount_restrictions';

    /**
     * @var array The attributes that are mass assignable.
     */
    protected $fillable = [
        'discount_id',
        'discountable_id',
        'discountable_type',
        'exclude'
    ];

    /**
     * Cast attributes to specific types
     *
     * @var array
     */
    protected $casts = [
        'exclude' => 'boolean',
        'discountable_id' => 'integer',
        'discount_id' => 'integer'
    ];

    /**
     * Scope - ofDiscount()
     *
     * @param Builder $query Query to extend
     * @param mixed $discount reference of discount (allows int id, array or object)
     * @return Builder
     */
    public function scopeOfDiscount(Builder $query, $discount) : Builder
    {
        return $query->where("discount_id", id($discount));
    }

    /**
     * Scope - excluded()
     *
     * @param Builder $query Query to extend
     * @param int $excluded whether condition is exclusive or inclusive
     * @return Builder
     */
    public function scopeExcluded(Builder $query, $excluded = 1) : Builder
    {
        return $query->where("exclude", $excluded);
    }

    /**
     * Relationship with discount restriction owner
     *
     * @return \Illuminate\Database\Eloquent\Relations\MorphTo
     */
    public function discountable() : MorphTo
    {
        return $this->morphTo('discountable');
    }

    /**
     * Define Eloquent relationship to discount class
     *
     * @return BelongsTo
     */
    public function discount() : BelongsTo
    {
        return $this->belongsTo(Discount::class);
    }

}
