<?php

namespace Mtc\MultiBuy\Contracts;

use Illuminate\Database\Eloquent\Model;

/**
 * Interface TypeContract
 * @package Mtc\MultiBuy\Contracts
 */
interface TypeContract
{
    /**
     * Apply discounted amounted
     *
     * @param Model $discount
     * @param $basket
     */
    public function apply(Model $discount, $basket);

    /**
     * Get Discounted values for item line
     *
     * @param $discount
     * @param $item
     * @return float
     */
    public function getDiscountedValues($discount, $item);
}
