<?php

namespace Mtc\MultiBuy\Types;

use Illuminate\Database\Eloquent\Model;
use Mtc\MultiBuy\Contracts\TypeContract;

/**
 * Class AmountOffAll
 * @package Mtc\MultiBuy
 */
class AmountOffAll implements TypeContract
{
    /**
     * Apply set amount discount to basket
     *
     * @param Model $discount
     * @return void
     */
    public function apply(Model $discount, $basket) : void
    {
        $discount->discounted_amount = $discount->deductable_amount < $discount->value1 ? $discount->deductable_amount : $discount->value1;
    }

    /**
     * Get Discounted values for item line
     *
     * @param $discount
     * @param $item
     * @return float
     */
    public function getDiscountedValues($discount, $item) {
        $quantity = $item->basket->items->sum('quantity');
        return [
            'discounted_amount' => round($discount->value1 / $quantity, 2) * $item->quantity,
        ];
    }
}
