<?php

namespace Mtc\MultiBuy\Types;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\App;
use Mtc\MultiBuy\Contracts\BasketDiscountRepositoryInterface;
use Mtc\MultiBuy\Contracts\TypeContract;

/**
 * Class AmountOff
 * @package Mtc\MultiBuy
 */
class AmountOff implements TypeContract
{
    /**
     * @var null
     */
    protected $discount = null;

    /**
     * Apply set amount discount to available basket items
     *
     * @param Model $discount
     * @return void
     */
    public function apply(Model $discount, $basket)
    {
        $this->discount = $discount;
        $this->basket = $basket;
        $basket_discount_repository = App::make(BasketDiscountRepositoryInterface::class);
        $basket_discount_repository->setBasket($basket);
        $applicable_items = $basket_discount_repository->getDiscountApplicableItems($discount);
        //Total discounted amount by this discount
        $discount->discounted_amount = $applicable_items->sum(function($item) {
            return $this->applyToItem($item);
        });
    }

    /**
     * Apply set amount discount to item
     *
     * @param $item
     * @return float|int
     */
    protected function applyToItem($item) {
        return ($item->unit_price < $this->discount->value1 ? $item->unit_price : $this->discount->value1) * $item->quantity;
    }

    /**
     * Get Discounted values for item line
     *
     * @param $discount
     * @param $item
     * @return float
     */
    public function getDiscountedValues($discount, $item) {
        return [
            'discounted_amount' => round($this->applyToItem($item), 2)
        ];
    }
}
