<?php

namespace Mtc\MultiBuy\Restrictions;

use Mtc\MultiBuy\Discount;

/**
 * Class BrandRestriction
 * @package Mtc\MultiBuy\Restrictions
 */
class BrandRestriction
{
    /**
     * @param Discount $discount
     * @param $item
     * @param $restriction
     * @param $restrictions_count
     * @return bool
     */
    public function validate(Discount $discount, $item, $restriction, $restrictions_count): bool
    {
        // Discount doesn't have any restriction
        if (!$restrictions_count['excluded'] && !$restrictions_count['included']) {
            return false;
        }

        $brands = $item->purchasable->brands ?: $item->purchasable->item->brands;
        $restriction_brands_exists = $brands
            ->contains('id', $restriction->discountable_id);

        // Discount contains only excluded restrictions
        if ($restrictions_count['excluded'] && !$restrictions_count['included']) {
            return !(bool)$restriction_brands_exists;
        }

        // Discount contains only included restrictions
        if ($restrictions_count['included'] && !$restrictions_count['excluded']) {
            return (bool)$restriction_brands_exists;
        }

        // Discount contains both included and excluded restrictions
        return $restriction->exclude ? !(bool)$restriction_brands_exists : (bool)$restriction_brands_exists;
    }
}
