<?php

namespace Mtc\MtcPay\Providers;

use Illuminate\Support\Facades\Event;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Route;

class MtcPayServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap the application services.
     */
    public function boot()
    {
        $this->loadTranslationsFrom(dirname(__DIR__, 2) . '/resources/lang', 'mtc_pay');

        $this->app['payment']->extend('mtc_pay', function($app) {
            return $this->app->make(config('mtc_pay.payment_gateway_class'));
        });

        if ($this->app->runningInConsole()) {
            // JS assets
            $this->publishes([
               dirname(__DIR__, 2) . '/resources/js' => resource_path('js/vendor'),
            ], 'assets');

            // Config
            $this->publishes([
                dirname(__DIR__, 2) . '/config/mtc_pay.php',
            ], 'config');

            // Translations
            $this->publishes([
                dirname(__DIR__, 2) . '/resources/lang' => $this->app->langPath('vendor/mtc_pay'),
            ]);
        }

        Route::middleware('web')->group(dirname(__DIR__, 2) . '/routes/web.php');
    }

    /**
     * Register the application services
     */
    public function register()
    {
        $this->mergeConfigFrom(dirname(__DIR__, 2) . '/config/mtc_pay.php', 'mtc_pay');
    }
}