<?php

namespace Mtc\MtcPay;

use Mtc\Foundation\Contracts\InstallableComponent;
use Mtc\MtcPay\Providers\MtcPayServiceProvider;

class Installer implements InstallableComponent
{
    /**
     * Define what needs to be published.
     *
     * @return array
     */
    public function publish(): array
    {
        return [
            [
                '--provider' => MtcPayServiceProvider::class,
                '--tag' => 'assets',
            ],
            [
                '--provider' => MtcPayServiceProvider::class,
                '--tag' => 'config',
            ],
        ];
    }

    /**
     * Whether npm should be run to compile assets after installation has been done
     *
     * @return bool
     */
    public function shouldRunNpm(): bool
    {
        return true;
    }

    /**
     * Provide a classname of seeder that should be called
     * In case of no seed required provide an empty string
     *
     * @return string
     */
    public function seed(): string
    {
        return '';
    }

    /**
     * List of npm packages and their version restrictions
     *
     * @return array
     */
    public function npmDependencies(): array
    {
        return [];
    }
}