<?php

namespace Mtc\Login;

use Illuminate\Support\Facades\Http;

/**
 * Class LoginService
 *
 * @package Mtc\Login
 */
class LoginService
{
    /**
     * Check if provided credentials are for a valid user
     *
     * @param $email
     * @param $password
     * @return array|bool|mixed|null
     */
    public function isValidUser($email, $password)
    {
        $response = Http::post($this->endpoint('api/staff_login.php'), [
            'email' => $email,
            'password' => $password
        ]);

        $response = $response->json();
        return is_array($response) ? $response : null;
    }

    /**
     * Perform a search for old emails in the system from the list
     *
     * @param array $emails
     * @return array|bool|mixed|null
     */
    public function filterOldUsers($emails = [])
    {
        $response = Http::post($this->endpoint('api/staff/check-old'), [
            'api_token' => config('mtc_login.api_token'),
            'emails' => $emails,
        ]);

        $response = json_decode($response->getBody(), true);
        return is_array($response) ? $response : null;
    }

    /**
     * Find the endpoint
     *
     * @param $path
     * @return string
     */
    protected function endpoint($path)
    {
        return rtrim(config('mtc_login.api_domain'), '/') . '/' . ltrim($path, '/');
    }
}
