<?php

namespace Mtc\Login\Providers;

use Illuminate\Auth\Events\Attempting;
use Illuminate\Foundation\Support\Providers\EventServiceProvider;
use Mtc\Login\Listeners\ValidateMtcLogin;

/**
 * Class LoginServiceProvider
 *
 * @package Mtc\Login
 */
class LoginServiceProvider extends EventServiceProvider
{
    /**
     * Event listener registration
     *
     * @var array
     */
    protected $listen = [
        Attempting::class => [
            ValidateMtcLogin::class
        ]
    ];

    /**
     * Register service
     */
    public function register()
    {
        $this->mergeConfigFrom(dirname(__DIR__, 2) . '/config/mtc_login.php', 'mtc_login');
    }
}