<?php

namespace Mtc\Login\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\App;
use Mtc\Login\LoginService;

/**
 * Class CheckOldStaff
 *
 * @package Mtc\Login
 */
class CheckOldStaff implements ShouldQueue
{
    use Dispatchable;
    use InteractsWithQueue;
    use Queueable;
    use SerializesModels;

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        /** @var LoginService $service */
        $service = App::make(LoginService::class);
        $emails = App::make(config('auth.providers.users.model'))->newQuery()
            ->where('email', 'like', '%@mtcmedia.co.uk')
            ->pluck('email')
            ->toArray();

        $old_emails = $service->filterOldUsers($emails);

        if (empty($old_emails)) {
            return;
        }

        App::make(config('auth.providers.users.model'))->newQuery()
            ->whereIn('email', $old_emails)
            ->delete();
    }
}
