<?php

namespace Tests\Unit;

use Mtc\AutomotiveSpecs\VehicleValuation;
use Mtc\MotorCheck\Maps\MotorSpecsToValuationMap;
use Mtc\Tests\TestCase;

class MotorSpecValuationMapTest extends TestCase
{
    public function testPricesOnAutotraderValuation()
    {
        $mapper = new MotorSpecsToValuationMap(new VehicleValuation());
        $valuation = $mapper->map([
            'autotraderValuation' => [
                'valuation' => [
                    'retail' => 123,
                    'partExchange' => 111,
                ]
            ]
        ]);

        self::assertEquals(123, $valuation->retail);
        self::assertEquals(111, $valuation->part_exchange);
    }

    public function testPricesOnVipValuation()
    {
        $mapper = new MotorSpecsToValuationMap(new VehicleValuation());
        $valuation = $mapper->map([
            'vipValuation' => [
                'forecourtGood' => 123,
                'tradeinGood' => 111,
            ]
        ]);

        self::assertEquals(123, $valuation->retail);
        self::assertEquals(111, $valuation->part_exchange);
    }

    public function testUnknownValuationType()
    {
        $this->expectException(\Exception::class);
        $mapper = new MotorSpecsToValuationMap(new VehicleValuation());
        $mapper->map([
            'random' => [
                'retail' => 123,
                'part_exchange' => 111,
            ]
        ]);

    }
}
