<?php

namespace Mtc\MotorCheck\Maps;

use Mtc\AutomotiveSpecs\VehicleRisks;
use Mtc\MotorCheck\Contracts\MotorCheckRiskMapContract;

class MotorCheckRiskMap implements MotorCheckRiskMapContract
{
    public function __construct(protected VehicleRisks $risks)
    {
    }

    public function map(array $risk_data): VehicleRisks
    {
        $issues = $risk_data['data']['issues'];
        $this->risks->setValuesFromArray([
            'finance' => !empty($issues['finance']['flag']) ? $issues['finance']['message'] : false,
            'mileage' => !empty($issues['mileage']['flag']) ? $issues['mileage']['message'] : false,
            'at_risk' => !empty($issues['atRisk']['flag']) ? $issues['atRisk']['message'] : false,
            'write_off' => !empty($issues['writeOff']['flag']) ? $issues['writeOff']['message'] : false,
            'condition' => !empty($issues['conditionAlerts']['flag']) ? $issues['conditionAlerts']['message'] : false,
            'scrapped' => !empty($issues['scrapped']['flag']) ? $issues['scrapped']['message'] : false,
            'stolen' => !empty($issues['stolen']['flag']) ? $issues['stolen']['message'] : false,
            'keepers' => !empty($issues['keepers']['flag']) ? $issues['keepers']['message'] : false,
            'plate_change' => !empty($issues['plateChange']['flag']) ? $issues['plateChange']['message'] : false,
            'colour_changes' => !empty($issues['colourChanges']['flag']) ? $issues['colourChanges']['message'] : false,
            'mot_history' => !empty($issues['motHistory']['flag']) ? $issues['motHistory']['message'] : false,
            'tax_and_sorn' => !empty($issues['taxAndSorn']['flag']) ? $issues['taxAndSorn']['message'] : false,
            'origin_and_use' => !empty($issues['originAndUse']['flag']) ? $issues['originAndUse']['message'] : false,
        ]);
        return $this->risks;
    }
}
