<?php

namespace Tests\Unit;

use Illuminate\Http\Client\Request;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Http;
use Mtc\MotorCheck\Exceptions\NotFoundException;
use Mtc\MotorCheck\Exceptions\UnauthorizedRequestException;
use Mtc\MotorCheck\Services\MotorCheckApi;
use Mtc\MotorCheck\Services\MotorSpecsApi;
use Mtc\Tests\TestCase;

class UnauthorizedApiLoginTest extends TestCase
{
    protected function getEnvironmentSetUp($app)
    {
        Http::fake([
            "https://staging.motorspecs.com/oauth" =>  Http::response(['title' => 'invalid_client'], 400),
            "https://trade-api.motorcheck.co.uk/api/v1/oauth/token" =>  Http::response(['title' => 'invalid_client'], 400),
            '*' => Http::response(['result' => 'wildcard'])
        ]);
    }

    public function testMotorspecsLoginThrowsException()
    {
        $config = [
            'live' => false,
            'username' => '',
            'password' => '',
        ];
        $this->expectException(UnauthorizedRequestException::class);
        (new MotorSpecsApi($config))->getVipValuation('ABC123', 123);
    }

    public function testMotorcheckLoginThrowsException()
    {
        $config = [
            'username' => '',
            'password' => '',
        ];
        $this->expectException(UnauthorizedRequestException::class);
        (new MotorCheckApi($config))->getReport('ABC123');
    }
}
