<?php

namespace Mtc\MotorCheck\Models;

use Illuminate\Database\Eloquent\Model;

/**
 * Class MotorCheckSpec
 *
 * @property string $vrm
 * @property int $mileage
 * @property string $uuid
 * @property array $identity
 * @property array $standard
 */
class MotorCheckSpec extends Model
{
    protected $table = 'motor_check_specs';

    protected $fillable = [
        'vrm',
        'mileage',
        'identity',
        'standard',
    ];

    protected $casts = [
        'identity' => 'array',
        'standard' => 'array',
    ];
}
