<?php

namespace Mtc\MotorCheck\Models;

use Illuminate\Database\Eloquent\Model;

/**
 * Class MotorCheckValuation
 *
 * @property string $vrm
 * @property int $mileage
 * @property array $vipValuation
 * @property array $autotraderValuation
 */
class MotorCheckValuation extends Model
{
    protected $table = 'motor_check_valuations';

    protected $fillable = [
        'vrm',
        'mileage',
        'vipValuation',
        'autotraderValuation',
    ];

    protected $casts = [
        'vipValuation' => 'array',
        'autotraderValuation' => 'array',
    ];
}
