<?php

namespace Mtc\MotorCheck\Providers;

use Illuminate\Support\ServiceProvider;
use Mtc\MotorCheck\Contracts\MotorCheckRiskMapContract;
use Mtc\MotorCheck\Contracts\MotorSpecsToValuationMapContract;
use Mtc\MotorCheck\Contracts\MotorSpecsToVehicleSpecificationContract;
use Mtc\MotorCheck\Services\MotorCheckApi;
use Mtc\MotorCheck\Services\MotorCheckService;
use Mtc\AutomotiveSpecs\Facades\AutoSpecs;
use Mtc\MotorCheck\Services\MotorSpecsApi;

class MotorCheckProvider extends ServiceProvider
{
    public function register()
    {
        $this->mergeConfigFrom(dirname(__DIR__, 2) . '/config/motor_check.php', 'motor_check');
        $this->loadMigrationsFrom(__DIR__ . '/../../database/migrations/');

        $this->app->bind(MotorSpecsToVehicleSpecificationContract::class, \config('motor_check.spec_map_class'));
        $this->app->bind(MotorSpecsToValuationMapContract::class, \config('motor_check.valuation_map_class'));
        $this->app->bind(MotorCheckRiskMapContract::class, \config('motor_check.risk_map_class'));
    }

    public function boot()
    {
        $this->app->bind(MotorCheckApi::class, function () {
            return new MotorCheckApi([
                'username' => config('motor_check.username'),
                'password' => config('motor_check.password'),
            ]);
        });

        $this->app->bind(MotorSpecsApi::class, function () {
            return new MotorSpecsApi([
                'live' => config('motor_check.specs_live'),
                'username' => config('motor_check.specs_username'),
                'password' => config('motor_check.specs_password'),
            ]);
        });

        $this->app->bind(MotorCheckService::class, function () {
            return new MotorCheckService(
                config('motor_check', []),
                $this->app->make(MotorSpecsApi::class),
                $this->app->make(MotorCheckApi::class),
                $this->app->make(MotorSpecsToVehicleSpecificationContract::class),
                $this->app->make(MotorSpecsToValuationMapContract::class),
                $this->app->make(MotorCheckRiskMapContract::class),
            );
        });

        AutoSpecs::register('motor-check', function () {
            return $this->app->make(MotorCheckService::class);
        });

        $this->publishes([
            __DIR__ . '/../../config/motor_check.php' => config_path('motor_check.php'),
        ], 'config');
    }
}
