<?php

namespace Mtc\MotorCheck\Maps;

use Mtc\AutomotiveSpecs\VehicleValuation;
use Mtc\MotorCheck\Contracts\MotorSpecsToValuationMapContract;

class MotorSpecsToValuationMap implements MotorSpecsToValuationMapContract
{
    public function __construct(protected VehicleValuation $spec)
    {
    }

    public function map(array $valuation_data): VehicleValuation
    {
        if (isset($valuation_data['autotraderValuation'])) {
            return $this->mapAutoTrader($valuation_data);
        }

        if (isset($valuation_data['vipValuation'])) {
            return $this->mapVipValuation($valuation_data);
        }

        throw new \Exception('Unknown Valuation');
    }

    public function mapAutoTrader(array $valuation_data): VehicleValuation
    {
        $this->spec->setValuesFromArray([
            'part_exchange' => $valuation_data['autotraderValuation']['valuation']['partExchange'] ?? 0,
            'retail' => $valuation_data['autotraderValuation']['valuation']['retail'] ?? 0,
        ]);
        return $this->spec;
    }

    public function mapVipValuation(array $valuation_data): VehicleValuation
    {
        $this->spec->setValuesFromArray([
            'part_exchange' => $valuation_data['vipValuation']['tradeinGood'] ?? 0,
            'retail' => $valuation_data['vipValuation']['forecourtGood'] ?? 0,
        ]);
        return $this->spec;
    }
}
