<?php

namespace Mtc\Money;

use Mtc\Core\Currency as CurrencyModel;
/**
 * Price Currency
 *
 * @package Mtc\Money
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class Currency
{
    /**
     * Find the default currency
     *
     * @return mixed
     */
    public function getDefaultCurrency()
    {
        return config('currencies.default_currency');
    }

    /**
     * Get current currency
     *
     * @return string
     */
    public function getCurrentCurrency()
    {
        return session('selected_currency', $this->getDefaultCurrency());
    }

    /**
     * Set the current currency
     *
     * @param string $currency
     * @return void
     */
    public function setActiveCurrency($currency)
    {
        session()->put('selected_currency', $currency);
    }

    /**
     * Get amount in currency
     *
     * @param $amount
     * @param string $currency
     * @return float|int
     */
    public function inCurrency($amount, $currency = null)
    {
        $currency = $currency ?? $this->getCurrentCurrency();
        $selected_currency = CurrencyModel::query()
            ->where('currency', $currency)
            ->active()
            ->first();

        return $amount * $selected_currency->ratio;
    }

    /**
     * Get amount in base currency
     *
     * @param float $amount
     * @param string $currency
     * @return float|int
     */
    public function inBaseCurrency($amount, $currency)
    {
        $selected_currency = CurrencyModel::query()
            ->where('currency', $currency)
            ->active()
            ->first();

        return $amount / $selected_currency->ratio;
    }
}
