<?php

namespace Mtc\Money;

/**
 * Price Modifier Class
 *
 * Individual price modifiers to change the total for
 * a price (e.g. sale, multi-buy discounts, member discounts)
 *
 * @package Mtc\Money
 * @author Craig McCreath <craig.mccreath@mtcmedia.co.uk>
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class PriceModifier
{
    /**
     * The name of the modifier to be displayed.
     *
     * @var string
     */
    public $name = '';

    /**
     * The type of modification taking place. e.g. delivery
     *
     * @var string
     */
    public $type = '';

    /**
     * The value of of the modification (+/-)
     *
     * @var float
     */
    public $value = 0;

    /**
     * The value of of the modification (+/-)
     *
     * @var float
     */
    public $order = 10;

    /**
     * PriceModifier constructor.
     *
     * @param $name
     * @param $value
     * @param $type
     * @param int $order
     */
    public function __construct($name, $value, $type, $order = 10)
    {
        $this->name = $name;
        $this->value = $value;
        $this->type = $type;
        $this->order = $order;
    }
}
