<?php

namespace Mtc\Money;

use Mtc\Core\Currency as CurrencyModel;
/**
 * Price Currency
 *
 * @package Mtc\Money
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class Currency
{
    /**
     * Get the locale of the price
     *
     * @return mixed
     */
    public function getLocale()
    {
        $currency = session('selected_currency', config('currencies.default_currency'));
        $locales = config('currencies.locales', []);
        return $locales[$currency];
    }

    /**
     * Set the  locale on app
     */
    public function setLocale($locale)
    {
        setlocale(LC_MONETARY, $locale);
    }

    /**
     * Find the default locale
     *
     * @return mixed
     */
    public function getDefaultLocale()
    {
        $locales = config('currencies.locales', []);
        return $locales[config('currencies.default_currency')];
    }

    /**
     * Get current currency
     *
     * @return string
     */
    public function getCurrentCurrency()
    {
        return array_search($this->getLocale(), config('currencies.locales', []));
    }

    /**
     * Get amount in currency
     *
     * @param $amount
     * @param string $currency
     * @return float|int
     */
    public function inCurrency($amount, $currency = null)
    {
        $currency = $currency ?? $this->getCurrentCurrency();
        $selected_currency = CurrencyModel::query()
            ->where('currency', $currency)
            ->active()
            ->first();

        return $amount * $selected_currency->ratio;
    }

    /**
     * Get amount in base currency
     *
     * @param float $amount
     * @param string $currency
     * @return float|int
     */
    public function inBaseCurrency($amount, $currency)
    {
        $selected_currency = CurrencyModel::query()
            ->where('currency', $currency)
            ->active()
            ->first();

        return $amount / $selected_currency->ratio;
    }
}
