<?php
/**
 * Phinx config. Copy this file into the root of the website and set up the DB details. See README.md for more details.
 *
 * @author Aleksey Lavrinenko <aleksey.lavrinenko@gmail.com>
 * @version 07.01.2017.
 */
ini_set('display_errors', 1);

require_once __DIR__ . '/vendor/autoload.php';

return [
    'paths' => [
        'migrations' => 'db/migrations',
        'seeds' => 'db/seeds',
    ],
    'templates' => [
        'file' => 'vendor/mtcmedia/migrations/src/Migration.template.php.tpl',
    ],
    'migration_base_class' => \MtcMedia\Migrations\Migration::class,
    'environments' => [
        'default_migration_table' => 'migrations',
        'default_database' => 'staging',
        'staging' => [
            'adapter' => 'mysql',
            'host' => 'localhost',
            'name' => '',
            'user' => '',
            'pass' => '',
            'port' => 3306,
        ],
        'live' => [
            'adapter' => 'mysql',
            'host' => 'localhost',
            'name' => '',
            'user' => '',
            'pass' => '',
            'port' => 3306,
        ],
    ],
];
