<?php

use MtcMedia\Migrations\ExtendedBlueprint;
use MtcMedia\Migrations\Migration;

class CreateQueueJobs extends Migration
{
    protected $table_name = 'queue_jobss';

    public function up()
    {
        $this->schema->create($this->table_name, function (ExtendedBlueprint $table) {
            $table->increments('id');
            $table->integer('queue_id', false, true);
            $table->string('name', 255)->index();
            $table->smallInteger('attempts', false, true)->default(0);
            $table->binary('data');

            $table->timestamps();
            $table->dateTime('done_at')->nullable();

            $table->foreign('queue_id')->references('id')->on('queues');
        });
    }

    public function down()
    {
        $this->schema->dropIfExists($this->table_name);
    }
}
