<?php

namespace MtcMedia\Migrations;

use Illuminate\Support\Composer;
use Illuminate\Support\ServiceProvider;

/**
 * Created 13/09/2018
 * @author Aleksey Lavrinenko <aleksey.lavrinenko@mtcmedia.co.uk>
 */
class MigrationsServiceProvider extends ServiceProvider
{
    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        $app = $this->app;

        if (!isset($app['events'])) {
            throw new \BadMethodCallException('Required $app["events"] is not defined');
        }

        // migrations table name
        $app['config']['database.migrations'] = 'migrations';

        if (!isset($app['files'])) {
            (new \Illuminate\Filesystem\FilesystemServiceProvider($app))->register();
        }

        $this->app->singleton('composer', function ($app) {
            return new Composer($app['files'], SITE_PATH);
        });

        (new \Illuminate\Database\MigrationServiceProvider($app))->register();
    }

    public function extendGrammar()
    {
        // @todo this is compied over from the phinx version. Can be fixed when the new type (`set`) is needed
        throw new \BadMethodCallException("Not implemented");
        // Override MySQL grammar the our own that provides extensions like the SET type
        $this->capsule->getConnection()->setSchemaGrammar(new ExtendedMySqlGrammar());

        // Override the bluprint with the extended version that provides a convenience set() method
        $this->schema->blueprintResolver(function($table, $callback) {
            return new ExtendedBlueprint($table, $callback);
        });
    }
}
