# Migrations

Migrations are using Phinx library and Laravel's Schema Builder. 
This package can be used on (probably) any site, including core and pre-core  

## Installation
```
composer require mtcmedia/migrations
```

Copy the configuration file template and fill in the DB details for staging and live.
```
cp vendor/mtcmedia/migrations/src/phinx.php ./
```

## Usage
### Creating Migration
```
php vendor/bin/phinx create ExampleMigration
```
This will create a migration in the `db/migrations` folder.

#### Example Migration
```
use Illuminate\Database\Schema\Blueprint;
use MtcMedia\Migrations\Migration;

class ExampleMigration extends Migration
{
    public function up()
    {
        $this->schema->create('test_table', function (Blueprint $table) {
            $table->increments('id');
        });
    }

    public function down()
    {
        $this->schema->dropIfExists('test_table');
    }
}
```

### Running Migrations
```
php vendor/bin/phinx migrate [-e staging]
```
Runs the migrations.


```
php vendor/bin/phinx rollback
```
Rolls back last migration(s).

### Add running migrations to the live git hook
```
php vendor/bin/phinx migrate -e live
```

## Documentation
Phinx documentation can be found here: 
https://book.cakephp.org/3.0/en/phinx.html

The `writing migrations` part doesn't apply really since it assumes a different 
driver, but might come in handy for runner options etc.

Laravel migrations can be found at https://laravel.com/docs/5.4/migrations, 
this is for how to write migrations. 

Note though, that this library is not the full laravel framework, 
so some stuff (e.g. artisan command) will not apply. Use this just as a guide 
to writing migrations.