<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\MorphTo;
use Illuminate\Support\Str;
use Mtc\MercuryDataModels\Factories\VehicleFeatureFactory;
use Mtc\MercuryDataModels\Traits\EnsuresSlug;

class VehicleFeature extends Model
{
    use HasFactory;
    use EnsuresSlug;

    protected $table = 'vehicle_features';

    protected $fillable = [
        'vehicle_id',
        'vehicle_type',
        'name',
        'slug',
        'category',
        'conditions',
    ];

    protected $casts = [
        'conditions' => 'array'
    ];

    protected $hidden = [
        'created_at',
        'updated_at',
    ];

    protected static function newFactory()
    {
        return VehicleFeatureFactory::new();
    }

    protected static function boot()
    {
        parent::boot();
        self::creating(fn (self $entry) => $entry->ensureSlug());
    }

    public function standardEquipment(): HasMany
    {
        return $this->hasMany(VehicleStandardEquipment::class, 'feature_id');
    }

    public function vehicle(): BelongsTo
    {
        return $this->belongsTo(Vehicle::class, 'vehicle_id');
    }

    public function owner(): MorphTo
    {
        return $this->morphTo('vehicle');
    }
}
