<?php

namespace Mtc\MercuryDataModels\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Mtc\MercuryDataModels\VehicleAttributeValue;

class VehicleAttributeValueFactory extends Factory
{
    protected $model = VehicleAttributeValue::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'vehicle_id' => random_int(1, 100),
            'attribute_id' => random_int(1, 100),
            'slug' => $this->faker->word(),
            'type' => $this->faker->word(),
            'value' => $this->faker->word(),
            'value_float' => random_int(1, 1000),
            'value_datetime' => $this->faker->dateTime(),
            'value_text' => $this->faker->sentence(),
            'order' => random_int(0, 100),
            'index' => random_int(0, 10),
        ];
    }
}
