<?php

namespace Mtc\MercuryDataModels;

use Mtc\MercuryDataModels\Factories\CurrencyFactory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Stancl\Tenancy\Database\Concerns\CentralConnection;

class Currency extends Model
{
    use CentralConnection;
    use HasFactory;

    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'currencies';

    /**
     * Mass assign attributes
     *
     * @var string[]
     */
    protected $fillable = [
        'code',
        'ratio',
    ];

    protected $visible = [
        'code',
        'ratio',
        'gbp_ratio',
    ];

    /**
     * Append attribute to response
     *
     * @var string[]
     */
    protected $appends = [
        'gbp_ratio',
    ];

    /**
     * Model Factory
     *
     * @return CurrencyFactory
     */
    protected static function newFactory()
    {
        return CurrencyFactory::new();
    }

    /***
     * Relationship with countries that use this currency
     *
     * @return HasMany
     */
    public function countries(): HasMany
    {
        return $this->hasMany(Country::class, 'currency_code');
    }

    /**
     * Add ratio for gbp (as EUR is base currency)
     *
     * @return float|int|null
     */
    public function getGbpRatioAttribute()
    {
        $gbp = self::query()->where('code', 'GBP')->first();
        return $gbp ? $this->ratio / $gbp->ratio : null;
    }
}
