<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('vehicles', function (Blueprint $table) {
            $table->string('motor_check_id')->index()->nullable();
        });
        Schema::table('vehicle_offers', function (Blueprint $table) {
            $table->string('motor_check_id')->index()->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('vehicles', function (Blueprint $table) {
            $table->dropColumn('motor_check_id');
        });
        Schema::table('vehicle_offers', function (Blueprint $table) {
            $table->dropColumn('motor_check_id');
        });
    }
};
