<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class VehicleView extends Model
{
    use HasFactory;

    protected $table = 'vehicle_views';

    protected $fillable = [
        'vehicle_id',
        'date',
        'hits',
        'quick_view_hits',
        'filter_views',
        'compare_email_requests',
    ];

    /**
     * Relationship with Vehicle
     *
     * @return BelongsTo
     */
    public function vehicle(): BelongsTo
    {
        return $this->belongsTo(Vehicle::class, 'vehicle_id');
    }
}
