<?php

namespace Mtc\MercuryDataModels\Services\Location;

use Mtc\MercuryDataModels\Contracts\LocatingServiceEngine;
use Mtc\MercuryDataModels\PostcodeGeo;

class PafLocationService implements LocatingServiceEngine
{
    public function find(string $postCode, string $country = 'GB'): ?object
    {
        $location = PostcodeGeo::query()
            ->where('postcode', $postCode)
            ->first();
        if ($location && $location->latitude > 90) {
            throw new \Exception('Invalid coordinates in PAF for ' . $postCode);
        }
        return $location;
    }
}
