CREATE TABLE IF NOT EXISTS "migrations" ("id" integer primary key autoincrement not null, "migration" varchar not null, "batch" integer not null);
CREATE TABLE IF NOT EXISTS "media" ("id" integer primary key autoincrement not null, "type" varchar not null, "src" varchar not null, "path" varchar not null, "alt_text" varchar, "title" varchar, "caption" varchar, "description" varchar, "upload_date" varchar not null, "uploaded_by" integer, "created_at" datetime, "updated_at" datetime, "external" tinyint(1), "image_provider" varchar, "last_used" datetime, "folder_id" integer, "source_filename" varchar);
CREATE INDEX "media_upload_date_index" on "media" ("upload_date");
CREATE INDEX "media_uploaded_by_index" on "media" ("uploaded_by");
CREATE TABLE IF NOT EXISTS "media_uses" ("id" integer primary key autoincrement not null, "media_id" integer not null, "owner_type" varchar not null, "owner_id" integer not null, "alt_text" varchar, "title" varchar, "caption" varchar, "description" varchar, "dimensions" varchar, "data" text, "allowed_sizes" text, "primary" tinyint(1), "secondary" tinyint(1), "flags" text, "order" integer not null default '0', "created_at" datetime, "updated_at" datetime, "interior" tinyint(1), "exterior" tinyint(1), "damages" tinyint(1));
CREATE INDEX "media_uses_owner_type_owner_id_index" on "media_uses" ("owner_type", "owner_id");
CREATE UNIQUE INDEX "media_uses_media_id_owner_id_owner_type_unique" on "media_uses" ("media_id", "owner_id", "owner_type");
CREATE INDEX "media_uses_media_id_index" on "media_uses" ("media_id");
CREATE INDEX "media_uses_primary_index" on "media_uses" ("primary");
CREATE INDEX "media_uses_secondary_index" on "media_uses" ("secondary");
CREATE TABLE IF NOT EXISTS "media_sizes" ("id" integer primary key autoincrement not null, "width" integer, "height" integer, "label" varchar, "created_at" datetime, "updated_at" datetime, "model" varchar);
CREATE TABLE IF NOT EXISTS "pages" ("id" integer primary key autoincrement not null, "title" varchar not null, "status" varchar not null, "published_at" datetime, "slug" varchar not null, "template_id" integer, "text" text, "seo" text, "meta" text, "data" text, "search_content" text, "created_at" datetime, "updated_at" datetime, "deleted_at" datetime, "category" varchar, "franchise_id" integer, "excerpt" varchar, "password" varchar, "featured" tinyint(1));
CREATE INDEX "pages_status_index" on "pages" ("status");
CREATE INDEX "pages_published_at_index" on "pages" ("published_at");
CREATE INDEX "pages_slug_index" on "pages" ("slug");
CREATE TABLE IF NOT EXISTS "page_users" ("id" integer primary key autoincrement not null, "page_id" integer not null, "user_id" integer not null);
CREATE INDEX "page_users_page_id_index" on "page_users" ("page_id");
CREATE INDEX "page_users_user_id_index" on "page_users" ("user_id");
CREATE TABLE IF NOT EXISTS "page_content" ("id" integer primary key autoincrement not null, "page_id" integer not null, "parent_id" integer, "global_content_id" integer, "element_id" integer, "name" varchar, "content" text, "created_at" datetime, "updated_at" datetime, "data" text, "order" integer not null default '0', "template_element_id" integer, "slug" varchar, "hidden" tinyint(1));
CREATE INDEX "page_content_page_id_index" on "page_content" ("page_id");
CREATE INDEX "page_content_parent_id_index" on "page_content" ("parent_id");
CREATE INDEX "page_content_global_content_id_index" on "page_content" ("global_content_id");
CREATE INDEX "page_content_element_id_index" on "page_content" ("element_id");
CREATE TABLE IF NOT EXISTS "comments" ("id" integer primary key autoincrement not null, "commentable_type" varchar, "commentable_id" integer, "parent_id" integer, "author_id" integer, "resolved_at" datetime, "content" text, "created_at" datetime, "updated_at" datetime);
CREATE INDEX "comments_commentable_type_commentable_id_index" on "comments" ("commentable_type", "commentable_id");
CREATE INDEX "comments_parent_id_index" on "comments" ("parent_id");
CREATE INDEX "comments_author_id_index" on "comments" ("author_id");
CREATE INDEX "comments_resolved_at_index" on "comments" ("resolved_at");
CREATE TABLE IF NOT EXISTS "comment_tagged_users" ("id" integer primary key autoincrement not null, "comment_id" integer, "user_id" integer, "created_at" datetime, "updated_at" datetime);
CREATE INDEX "comment_tagged_users_comment_id_index" on "comment_tagged_users" ("comment_id");
CREATE INDEX "comment_tagged_users_user_id_index" on "comment_tagged_users" ("user_id");
CREATE TABLE IF NOT EXISTS "global_content" ("id" integer primary key autoincrement not null, "name" varchar, "slug" varchar, "type" varchar, "content" text, "element_id" integer, "created_at" datetime, "updated_at" datetime, "ui_component" varchar, "available_from" datetime, "available_to" datetime, "preview_image" varchar);
CREATE INDEX "global_content_slug_index" on "global_content" ("slug");
CREATE INDEX "global_content_type_index" on "global_content" ("type");
CREATE INDEX "global_content_element_id_index" on "global_content" ("element_id");
CREATE TABLE IF NOT EXISTS "global_content_users" ("id" integer primary key autoincrement not null, "content_id" integer, "user_id" integer);
CREATE INDEX "global_content_users_content_id_index" on "global_content_users" ("content_id");
CREATE INDEX "global_content_users_user_id_index" on "global_content_users" ("user_id");
CREATE TABLE IF NOT EXISTS "content_elements" ("id" integer primary key autoincrement not null, "title" varchar not null, "slug" varchar, "subtitle" varchar, "icon" varchar, "category" varchar, "is_enabled" tinyint(1) not null default '1', "data" text, "created_at" datetime, "updated_at" datetime, "ui_component" varchar, "drag_and_drop" tinyint(1) not null default '0', "preview_image" varchar);
CREATE INDEX "content_elements_slug_index" on "content_elements" ("slug");
CREATE INDEX "content_elements_is_enabled_index" on "content_elements" ("is_enabled");
CREATE TABLE IF NOT EXISTS "content_element_fields" ("id" integer primary key autoincrement not null, "element_id" integer not null, "child_element_id" integer, "field_type" varchar not null, "name" varchar not null, "data" text, "meta" text, "order" integer not null default '0', "created_at" datetime, "updated_at" datetime, "slug" varchar);
CREATE INDEX "content_element_fields_element_id_index" on "content_element_fields" ("element_id");
CREATE INDEX "content_element_fields_child_element_id_index" on "content_element_fields" ("child_element_id");
CREATE INDEX "content_element_fields_field_type_index" on "content_element_fields" ("field_type");
CREATE INDEX "content_element_fields_order_index" on "content_element_fields" ("order");
CREATE TABLE IF NOT EXISTS "menus" ("id" integer primary key autoincrement not null, "title" varchar not null, "slug" varchar, "description" text, "first_child_element_id" integer, "data" text, "is_enabled" tinyint(1) not null default '1', "created_at" datetime, "updated_at" datetime, "meta" text, "franchise_id" integer);
CREATE INDEX "menus_slug_index" on "menus" ("slug");
CREATE INDEX "menus_is_enabled_index" on "menus" ("is_enabled");
CREATE TABLE IF NOT EXISTS "menu_entries" ("id" integer primary key autoincrement not null, "menu_id" integer not null, "element_id" integer, "_lft" integer not null default '0', "_rgt" integer not null default '0', "parent_id" integer, "is_enabled" tinyint(1) not null default '0', "name" varchar not null, "url" varchar, "content" text, "data" text, "item_type" varchar, "item_id" integer, "created_at" datetime, "updated_at" datetime, "linked_model_type" varchar, "linked_model_id" integer, "external" tinyint(1), "css_class" varchar);
CREATE INDEX "menu_entries__lft__rgt_parent_id_index" on "menu_entries" ("_lft", "_rgt", "parent_id");
CREATE INDEX "menu_entries_item_type_item_id_index" on "menu_entries" ("item_type", "item_id");
CREATE INDEX "menu_entries_menu_id_index" on "menu_entries" ("menu_id");
CREATE INDEX "menu_entries_element_id_index" on "menu_entries" ("element_id");
CREATE INDEX "menu_entries_is_enabled_index" on "menu_entries" ("is_enabled");
CREATE TABLE IF NOT EXISTS "page_templates" ("id" integer primary key autoincrement not null, "name" varchar not null, "slug" varchar, "description" text, "seo_defaults" text, "meta" text, "status" varchar not null default 'draft', "updated_by" integer, "created_at" datetime, "updated_at" datetime);
CREATE INDEX "page_templates_slug_index" on "page_templates" ("slug");
CREATE INDEX "page_templates_status_index" on "page_templates" ("status");
CREATE INDEX "page_templates_updated_by_index" on "page_templates" ("updated_by");
CREATE TABLE IF NOT EXISTS "page_template_elements" ("id" integer primary key autoincrement not null, "template_id" integer not null, "element_id" integer, "global_content_id" integer, "name" varchar not null, "description" text, "hint" varchar, "is_list" tinyint(1) not null default '0', "max_repeat_count" integer not null default '0', "order" integer not null default '0', "created_at" datetime, "updated_at" datetime, "field_type" varchar, "data" text, "meta" text);
CREATE INDEX "page_template_elements_template_id_index" on "page_template_elements" ("template_id");
CREATE INDEX "page_template_elements_element_id_index" on "page_template_elements" ("element_id");
CREATE INDEX "page_template_elements_global_content_id_index" on "page_template_elements" ("global_content_id");
CREATE INDEX "page_template_elements_order_index" on "page_template_elements" ("order");
CREATE TABLE IF NOT EXISTS "notifications" ("id" integer primary key autoincrement not null, "recipient_permission_level" varchar, "severity" varchar not null, "message" varchar not null, "details" text, "source" varchar, "read_at" datetime, "read_by" integer, "created_at" datetime, "updated_at" datetime);
CREATE INDEX "notifications_recipient_permission_level_index" on "notifications" ("recipient_permission_level");
CREATE INDEX "notifications_severity_index" on "notifications" ("severity");
CREATE INDEX "notifications_source_index" on "notifications" ("source");
CREATE INDEX "notifications_read_at_index" on "notifications" ("read_at");
CREATE INDEX "notifications_read_by_index" on "notifications" ("read_by");
CREATE TABLE IF NOT EXISTS "enquiries" ("id" integer primary key autoincrement not null, "reason_type" varchar, "reason_id" integer, "form_id" integer, "ingested_at" datetime, "email" varchar, "submitter_type" varchar, "submitter_id" integer, "type_id" integer, "status_id" integer, "title" varchar, "message" text, "details" text, "data" text, "assigned_user_id" integer, "customer_id" integer, "created_at" datetime, "updated_at" datetime, "deleted_at" datetime, "valuation_id" integer, "confirmation_sent" tinyint(1), "source" varchar);
CREATE INDEX "enquiries_reason_type_reason_id_index" on "enquiries" ("reason_type", "reason_id");
CREATE INDEX "enquiries_submitter_type_submitter_id_index" on "enquiries" ("submitter_type", "submitter_id");
CREATE INDEX "enquiries_form_id_index" on "enquiries" ("form_id");
CREATE INDEX "enquiries_ingested_at_index" on "enquiries" ("ingested_at");
CREATE INDEX "enquiries_email_index" on "enquiries" ("email");
CREATE INDEX "enquiries_type_id_index" on "enquiries" ("type_id");
CREATE INDEX "enquiries_status_id_index" on "enquiries" ("status_id");
CREATE INDEX "enquiries_assigned_user_id_index" on "enquiries" ("assigned_user_id");
CREATE INDEX "enquiries_customer_id_index" on "enquiries" ("customer_id");
CREATE TABLE IF NOT EXISTS "enquiry_status_history" ("id" integer primary key autoincrement not null, "enquiry_id" integer, "status_id" integer not null, "user_id" integer, "from_customer" tinyint(1), "created_at" datetime, "updated_at" datetime);
CREATE INDEX "enquiry_status_history_enquiry_id_index" on "enquiry_status_history" ("enquiry_id");
CREATE INDEX "enquiry_status_history_status_id_index" on "enquiry_status_history" ("status_id");
CREATE INDEX "enquiry_status_history_user_id_index" on "enquiry_status_history" ("user_id");
CREATE INDEX "enquiry_status_history_from_customer_index" on "enquiry_status_history" ("from_customer");
CREATE TABLE IF NOT EXISTS "enquiry_messages" ("id" integer primary key autoincrement not null, "enquiry_id" integer, "user_id" integer, "new_status_id" integer, "from_customer" tinyint(1), "message" text, "created_at" datetime, "updated_at" datetime);
CREATE INDEX "enquiry_messages_enquiry_id_index" on "enquiry_messages" ("enquiry_id");
CREATE INDEX "enquiry_messages_user_id_index" on "enquiry_messages" ("user_id");
CREATE INDEX "enquiry_messages_new_status_id_index" on "enquiry_messages" ("new_status_id");
CREATE INDEX "enquiry_messages_from_customer_index" on "enquiry_messages" ("from_customer");
CREATE TABLE IF NOT EXISTS "enquiry_subscribers" ("id" integer primary key autoincrement not null, "enquiry_id" integer not null, "user_id" integer not null);
CREATE INDEX "enquiry_subscribers_enquiry_id_index" on "enquiry_subscribers" ("enquiry_id");
CREATE INDEX "enquiry_subscribers_user_id_index" on "enquiry_subscribers" ("user_id");
CREATE TABLE IF NOT EXISTS "enquiry_actions" ("id" integer primary key autoincrement not null, "enquiry_id" integer not null, "action_name" varchar not null, "data" text, "processed_at" datetime, "failed_at" datetime, "context" varchar, "created_at" datetime, "updated_at" datetime, "attempts" integer not null default '0');
CREATE INDEX "enquiry_actions_enquiry_id_index" on "enquiry_actions" ("enquiry_id");
CREATE INDEX "enquiry_actions_action_name_index" on "enquiry_actions" ("action_name");
CREATE INDEX "enquiry_actions_processed_at_index" on "enquiry_actions" ("processed_at");
CREATE INDEX "enquiry_actions_failed_at_index" on "enquiry_actions" ("failed_at");
CREATE TABLE IF NOT EXISTS "enquiry_assigned_tags" ("id" integer primary key autoincrement not null, "enquiry_id" integer not null, "enquiry_tag_id" integer not null, "created_at" datetime, "updated_at" datetime);
CREATE INDEX "enquiry_assigned_tags_enquiry_id_enquiry_tag_id_index" on "enquiry_assigned_tags" ("enquiry_id", "enquiry_tag_id");
CREATE TABLE IF NOT EXISTS "enquiry_tags" ("id" integer primary key autoincrement not null, "name" varchar not null, "created_at" datetime, "updated_at" datetime);
CREATE INDEX "enquiry_tags_name_index" on "enquiry_tags" ("name");
CREATE TABLE IF NOT EXISTS "enquiry_statuses" ("id" integer primary key autoincrement not null, "name" varchar not null, "is_final" tinyint(1), "is_initial" tinyint(1), "created_at" datetime, "updated_at" datetime);
CREATE INDEX "enquiry_statuses_is_final_index" on "enquiry_statuses" ("is_final");
CREATE INDEX "enquiry_statuses_is_initial_index" on "enquiry_statuses" ("is_initial");
CREATE TABLE IF NOT EXISTS "enquiry_types" ("id" integer primary key autoincrement not null, "name" varchar not null, "notes" varchar, "created_at" datetime, "updated_at" datetime, "template_name" varchar);
CREATE TABLE IF NOT EXISTS "form_actions" ("id" integer primary key autoincrement not null, "form_id" integer not null, "action_name" varchar not null, "fields" text, "created_at" datetime, "updated_at" datetime);
CREATE INDEX "form_actions_form_id_index" on "form_actions" ("form_id");
CREATE INDEX "form_actions_action_name_index" on "form_actions" ("action_name");
CREATE TABLE IF NOT EXISTS "form_sections" ("id" integer primary key autoincrement not null, "form_id" integer not null, "name" varchar, "is_active" tinyint(1) not null default '1', "settings" text, "order" integer not null default '0', "created_at" datetime, "updated_at" datetime, "segments" text);
CREATE INDEX "form_sections_form_id_index" on "form_sections" ("form_id");
CREATE INDEX "form_sections_is_active_index" on "form_sections" ("is_active");
CREATE TABLE IF NOT EXISTS "form_questions" ("id" integer primary key autoincrement not null, "form_id" integer not null, "form_section_id" integer not null, "name" varchar, "type" varchar not null, "is_active" tinyint(1) not null default '1', "is_customers_email" tinyint(1) not null default '0', "is_enquiry_subject" tinyint(1) not null default '0', "description" text, "placeholder" varchar, "answer_options" text, "validation" varchar, "data" text, "settings" text, "order" integer not null default '0', "created_at" datetime, "updated_at" datetime, "segment" varchar, "deleted_at" datetime);
CREATE INDEX "form_questions_form_id_index" on "form_questions" ("form_id");
CREATE INDEX "form_questions_form_section_id_index" on "form_questions" ("form_section_id");
CREATE INDEX "form_questions_type_index" on "form_questions" ("type");
CREATE INDEX "form_questions_is_active_index" on "form_questions" ("is_active");
CREATE INDEX "form_questions_is_customers_email_index" on "form_questions" ("is_customers_email");
CREATE INDEX "form_questions_is_enquiry_subject_index" on "form_questions" ("is_enquiry_subject");
CREATE TABLE IF NOT EXISTS "pinned_items" ("id" integer primary key autoincrement not null, "owner_type" varchar, "owner_id" integer, "category" varchar, "pinned_item_type" varchar, "pinned_item_id" integer, "pinned_url" varchar, "title" varchar, "subtitle" varchar, "created_at" datetime, "updated_at" datetime);
CREATE INDEX "pinned_items_owner_type_owner_id_index" on "pinned_items" ("owner_type", "owner_id");
CREATE INDEX "pinned_items_pinned_item_type_pinned_item_id_index" on "pinned_items" ("pinned_item_type", "pinned_item_id");
CREATE INDEX "pinned_items_category_index" on "pinned_items" ("category");
CREATE TABLE IF NOT EXISTS "settings" ("id" integer primary key autoincrement not null, "tab" varchar not null, "section" varchar not null, "group" varchar not null, "name" varchar not null, "config_key" varchar not null, "type" varchar not null, "value" varchar, "min_tier" varchar, "validation_rules" text, "choices" text, "description" text, "order" integer not null default '99', "created_at" datetime, "updated_at" datetime, "clear_if_changed" text, "superadmin" tinyint(1), "feature" varchar, "value_text" text);
CREATE INDEX "settings_tab_index" on "settings" ("tab");
CREATE INDEX "settings_section_index" on "settings" ("section");
CREATE INDEX "settings_group_index" on "settings" ("group");
CREATE INDEX "settings_config_key_index" on "settings" ("config_key");
CREATE TABLE IF NOT EXISTS "filter_index" ("id" integer primary key autoincrement not null, "slug" varchar not null, "name" varchar, "filter_type" varchar not null, "filter_id" varchar not null, "order" integer not null default '0', "created_at" datetime, "updated_at" datetime);
CREATE INDEX "filter_index_filter_type_filter_id_index" on "filter_index" ("filter_type", "filter_id");
CREATE TABLE IF NOT EXISTS "body_styles" ("id" integer primary key autoincrement not null, "name" varchar not null, "autotrader_id" varchar, "created_at" datetime, "updated_at" datetime, "has_subcategories" tinyint(1), "small_if_under" integer, "large_if_above" integer);
CREATE INDEX "body_styles_autotrader_id_index" on "body_styles" ("autotrader_id");
CREATE TABLE IF NOT EXISTS "drivetrains" ("id" integer primary key autoincrement not null, "name" varchar not null, "autotrader_id" varchar, "created_at" datetime, "updated_at" datetime);
CREATE INDEX "drivetrains_autotrader_id_index" on "drivetrains" ("autotrader_id");
CREATE TABLE IF NOT EXISTS "fuel_types" ("id" integer primary key autoincrement not null, "name" varchar not null, "autotrader_id" varchar, "created_at" datetime, "updated_at" datetime, "ev_data" tinyint(1), "mpg_data" tinyint(1));
CREATE INDEX "fuel_types_autotrader_id_index" on "fuel_types" ("autotrader_id");
CREATE TABLE IF NOT EXISTS "transmissions" ("id" integer primary key autoincrement not null, "name" varchar not null, "autotrader_id" varchar, "created_at" datetime, "updated_at" datetime);
CREATE INDEX "transmissions_autotrader_id_index" on "transmissions" ("autotrader_id");
CREATE TABLE IF NOT EXISTS "vehicle_makes" ("id" integer primary key autoincrement not null, "name" varchar not null, "autotrader_id" varchar, "logo" varchar, "monochrome_logo" varchar, "created_at" datetime, "updated_at" datetime, "primary_colour" varchar, "secondary_colour" varchar, "cap_id" varchar, "lcv_cap_id" varchar);
CREATE INDEX "vehicle_makes_autotrader_id_index" on "vehicle_makes" ("autotrader_id");
CREATE TABLE IF NOT EXISTS "vehicle_models" ("id" integer primary key autoincrement not null, "make_id" integer not null, "name" varchar not null, "autotrader_id" varchar, "cap_id" varchar, "created_at" datetime, "updated_at" datetime, "lcv_cap_id" varchar);
CREATE INDEX "vehicle_models_autotrader_id_index" on "vehicle_models" ("autotrader_id");
CREATE INDEX "vehicle_models_cap_id_index" on "vehicle_models" ("cap_id");
CREATE TABLE IF NOT EXISTS "dealerships" ("id" integer primary key autoincrement not null, "name" varchar, "slug" varchar, "email" varchar, "contact_no" varchar, "media_id" integer, "contact_form_id" integer, "address1" varchar, "address2" varchar, "city" varchar, "county" varchar, "postcode" varchar, "country" varchar, "coordinates" varchar, "open_times" text, "data" text, "location_finance" varchar, "location_stock" varchar, "created_at" datetime, "updated_at" datetime, "timezone" varchar, "active" tinyint(1) not null default '1', "franchise_id" integer, "notes" text, "alt_open_times" text, "lat" numeric, "lng" numeric, "external_showroom_url" varchar, "template_id" integer, "second_alt_open_times" text);
CREATE INDEX "dealerships_slug_index" on "dealerships" ("slug");
CREATE INDEX "dealerships_location_finance_index" on "dealerships" ("location_finance");
CREATE INDEX "dealerships_location_stock_index" on "dealerships" ("location_stock");
CREATE TABLE IF NOT EXISTS "vehicle_offer_content" ("id" integer primary key autoincrement not null, "offer_id" integer not null, "parent_id" integer, "global_content_id" integer, "element_id" integer, "name" varchar, "content" text, "search_content" text, "created_at" datetime, "updated_at" datetime, "template_element_id" integer, "data" text, "order" integer not null default '0', "slug" varchar, "hidden" tinyint(1));
CREATE INDEX "vehicle_offer_content_offer_id_index" on "vehicle_offer_content" ("offer_id");
CREATE INDEX "vehicle_offer_content_parent_id_index" on "vehicle_offer_content" ("parent_id");
CREATE INDEX "vehicle_offer_content_global_content_id_index" on "vehicle_offer_content" ("global_content_id");
CREATE INDEX "vehicle_offer_content_element_id_index" on "vehicle_offer_content" ("element_id");
CREATE TABLE IF NOT EXISTS "reporting_stats" ("id" integer primary key autoincrement not null, "key" varchar not null, "date" date not null, "value" varchar, "created_at" datetime, "updated_at" datetime);
CREATE INDEX "reporting_stats_key_index" on "reporting_stats" ("key");
CREATE INDEX "reporting_stats_date_index" on "reporting_stats" ("date");
CREATE TABLE IF NOT EXISTS "sales_channel_history" ("id" integer primary key autoincrement not null, "channel" varchar not null, "was_successful" tinyint(1) not null default '0', "details" text, "created_at" datetime, "updated_at" datetime, "vehicle_id" integer);
CREATE INDEX "sales_channel_history_channel_index" on "sales_channel_history" ("channel");
CREATE INDEX "sales_channel_history_was_successful_index" on "sales_channel_history" ("was_successful");
CREATE TABLE IF NOT EXISTS "seo_defaults" ("id" integer primary key autoincrement not null, "section" varchar not null, "title" varchar, "description" varchar, "created_at" datetime, "updated_at" datetime, "og_image" integer);
CREATE UNIQUE INDEX "seo_defaults_section_unique" on "seo_defaults" ("section");
CREATE TABLE IF NOT EXISTS "reports" ("id" integer primary key autoincrement not null, "name" varchar not null, "type" varchar not null, "active" tinyint(1) not null default '0', "schedule" varchar, "format" varchar, "recipient" varchar, "columns" text, "conditions" text, "last_report_sent_at" datetime, "next_report_due_at" datetime, "created_at" datetime, "updated_at" datetime, "export_time" varchar, "export_day_of_week" integer, "export_day_of_month" integer);
CREATE INDEX "reports_created_at_index" on "reports" ("created_at");
CREATE INDEX "reports_name_index" on "reports" ("name");
CREATE INDEX "reports_type_index" on "reports" ("type");
CREATE INDEX "reports_active_index" on "reports" ("active");
CREATE INDEX "reports_last_report_sent_at_index" on "reports" ("last_report_sent_at");
CREATE INDEX "reports_next_report_due_at_index" on "reports" ("next_report_due_at");
CREATE TABLE IF NOT EXISTS "report_logs" ("id" integer primary key autoincrement not null, "report_id" integer not null, "succeeded" tinyint(1) not null, "details" varchar, "created_at" datetime, "updated_at" datetime);
CREATE INDEX "report_logs_created_at_index" on "report_logs" ("created_at");
CREATE INDEX "report_logs_report_id_index" on "report_logs" ("report_id");
CREATE INDEX "report_logs_succeeded_index" on "report_logs" ("succeeded");
CREATE INDEX "menu_entries_linked_model_type_linked_model_id_index" on "menu_entries" ("linked_model_type", "linked_model_id");
CREATE INDEX "pages_category_index" on "pages" ("category");
CREATE TABLE IF NOT EXISTS "seeds" ("id" integer primary key autoincrement not null, "seeder" varchar not null, "batch" integer, "created_at" datetime, "updated_at" datetime);
CREATE INDEX "seeds_seeder_index" on "seeds" ("seeder");
CREATE TABLE IF NOT EXISTS "seo_redirects" ("id" integer primary key autoincrement not null, "from" varchar not null, "to" varchar not null, "code" varchar not null, "created_at" datetime, "updated_at" datetime, "from_domain" varchar, "to_domain" varchar);
CREATE INDEX "seo_redirects_from_index" on "seo_redirects" ("from");
CREATE TABLE IF NOT EXISTS "franchises" ("id" integer primary key autoincrement not null, "name" varchar not null, "slug" varchar not null, "make_id" integer, "data" text, "logo" varchar, "created_at" datetime, "updated_at" datetime, "primary_colour" varchar, "secondary_colour" varchar);
CREATE UNIQUE INDEX "franchises_slug_unique" on "franchises" ("slug");
CREATE INDEX "franchises_make_id_index" on "franchises" ("make_id");
CREATE INDEX "page_content_order_index" on "page_content" ("order");
CREATE TABLE IF NOT EXISTS "offer_types" ("id" integer primary key autoincrement not null, "slug" varchar not null, "name" varchar not null, "template_id" integer, "data" text, "created_at" datetime, "updated_at" datetime, "parent_id" integer);
CREATE INDEX "offer_types_slug_index" on "offer_types" ("slug");
CREATE INDEX "offer_types_template_id_index" on "offer_types" ("template_id");
CREATE TABLE IF NOT EXISTS "dealership_holidays" ("id" integer primary key autoincrement not null, "dealership_id" integer not null, "date" date not null, "note" varchar, "created_at" datetime, "updated_at" datetime);
CREATE INDEX "dealership_holidays_dealership_id_index" on "dealership_holidays" ("dealership_id");
CREATE INDEX "dealership_holidays_date_index" on "dealership_holidays" ("date");
CREATE INDEX "page_content_template_element_id_index" on "page_content" ("template_element_id");
CREATE TABLE IF NOT EXISTS "vehicle_features" ("id" integer primary key autoincrement not null, "name" varchar not null, "slug" varchar not null, "category" varchar, "conditions" text, "created_at" datetime, "updated_at" datetime, "vehicle_id" integer not null, "vehicle_type" varchar);
CREATE INDEX "vehicle_features_slug_index" on "vehicle_features" ("slug");
CREATE INDEX "vehicle_features_category_index" on "vehicle_features" ("category");
CREATE INDEX "content_elements_drag_and_drop_index" on "content_elements" ("drag_and_drop");
CREATE TABLE IF NOT EXISTS "vehicle_views" ("id" integer primary key autoincrement not null, "vehicle_id" integer not null, "date" date not null, "hits" integer not null default '0', "filter_views" integer not null default '0', "created_at" datetime, "updated_at" datetime, "quick_view_hits" integer not null default '0', "compare_views" integer not null default '0');
CREATE UNIQUE INDEX "vehicle_views_vehicle_id_date_unique" on "vehicle_views" ("vehicle_id", "date");
CREATE INDEX "vehicle_views_vehicle_id_index" on "vehicle_views" ("vehicle_id");
CREATE INDEX "vehicle_views_date_index" on "vehicle_views" ("date");
CREATE TABLE IF NOT EXISTS "offer_views" ("id" integer primary key autoincrement not null, "offer_id" integer not null, "date" date not null, "hits" integer not null default '0', "filter_views" integer not null default '0', "created_at" datetime, "updated_at" datetime);
CREATE UNIQUE INDEX "offer_views_offer_id_date_unique" on "offer_views" ("offer_id", "date");
CREATE INDEX "offer_views_offer_id_index" on "offer_views" ("offer_id");
CREATE INDEX "offer_views_date_index" on "offer_views" ("date");
CREATE TABLE IF NOT EXISTS "vehicle_autotrader_data" ("id" integer primary key autoincrement not null, "vehicle_id" integer not null, "valuation" integer, "price_point" varchar, "price_position" integer, "search_results_7d" integer, "ad_views" integer, "created_at" datetime, "updated_at" datetime);
CREATE INDEX "vehicle_autotrader_data_vehicle_id_index" on "vehicle_autotrader_data" ("vehicle_id");
CREATE TABLE IF NOT EXISTS "property_categories" ("id" integer primary key autoincrement not null, "name" varchar not null, "slug" varchar not null, "active" tinyint(1) not null default '1', "data" text, "created_at" datetime, "updated_at" datetime);
CREATE INDEX "property_categories_name_index" on "property_categories" ("name");
CREATE INDEX "property_categories_slug_index" on "property_categories" ("slug");
CREATE INDEX "property_categories_active_index" on "property_categories" ("active");
CREATE TABLE IF NOT EXISTS "property_category_fields" ("id" integer primary key autoincrement not null, "category_id" integer not null, "slug" varchar not null, "name" varchar not null, "type" varchar not null, "order" integer not null, "active" tinyint(1) not null default '1', "validation" varchar, "choices" text, "data" text, "created_at" datetime, "updated_at" datetime);
CREATE INDEX "property_category_fields_category_id_index" on "property_category_fields" ("category_id");
CREATE INDEX "property_category_fields_slug_index" on "property_category_fields" ("slug");
CREATE INDEX "property_category_fields_type_index" on "property_category_fields" ("type");
CREATE INDEX "property_category_fields_order_index" on "property_category_fields" ("order");
CREATE INDEX "property_category_fields_active_index" on "property_category_fields" ("active");
CREATE TABLE IF NOT EXISTS "properties" ("id" integer primary key autoincrement not null, "category_id" integer not null, "slug" varchar not null, "name" varchar not null, "active" tinyint(1) not null default '1', "data" text, "created_at" datetime, "updated_at" datetime, "order" integer);
CREATE INDEX "properties_category_id_index" on "properties" ("category_id");
CREATE INDEX "properties_slug_index" on "properties" ("slug");
CREATE INDEX "properties_name_index" on "properties" ("name");
CREATE INDEX "properties_active_index" on "properties" ("active");
CREATE INDEX "vehicle_offer_content_template_element_id_index" on "vehicle_offer_content" ("template_element_id");
CREATE INDEX "vehicle_offer_content_order_index" on "vehicle_offer_content" ("order");
CREATE TABLE page_versions (id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, author_id INTEGER DEFAULT NULL, page_id INTEGER NOT NULL, is_active BOOLEAN NOT NULL, structure CLOB DEFAULT NULL COLLATE "BINARY", created_at DATETIME DEFAULT NULL, updated_at DATETIME DEFAULT NULL, deleted_at DATETIME DEFAULT NULL, uuid VARCHAR(255) NOT NULL COLLATE "BINARY", pending_review BOOLEAN DEFAULT NULL, request_changes BOOLEAN DEFAULT NULL);
CREATE INDEX page_versions_request_changes_index ON page_versions (request_changes);
CREATE INDEX page_versions_pending_review_index ON page_versions (pending_review);
CREATE INDEX page_versions_uuid_index ON page_versions (uuid);
CREATE INDEX page_versions_is_active_index ON page_versions (is_active);
CREATE INDEX page_versions_page_id_index ON page_versions (page_id);
CREATE INDEX page_versions_author_id_index ON page_versions (author_id);
CREATE TABLE vehicle_offer_content_history (id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, uuid VARCHAR(255) NOT NULL COLLATE "BINARY", offer_id INTEGER NOT NULL, author_id INTEGER DEFAULT NULL, is_active BOOLEAN NOT NULL, data CLOB DEFAULT NULL COLLATE "BINARY", created_at DATETIME DEFAULT NULL, updated_at DATETIME DEFAULT NULL, deleted_at DATETIME DEFAULT NULL, pending_review BOOLEAN DEFAULT NULL, request_changes BOOLEAN DEFAULT NULL);
CREATE INDEX vehicle_offer_content_history_request_changes_index ON vehicle_offer_content_history (request_changes);
CREATE INDEX vehicle_offer_content_history_pending_review_index ON vehicle_offer_content_history (pending_review);
CREATE INDEX vehicle_offer_content_history_deleted_at_index ON vehicle_offer_content_history (deleted_at);
CREATE INDEX vehicle_offer_content_history_is_active_index ON vehicle_offer_content_history (is_active);
CREATE INDEX vehicle_offer_content_history_author_id_index ON vehicle_offer_content_history (author_id);
CREATE INDEX vehicle_offer_content_history_offer_id_index ON vehicle_offer_content_history (offer_id);
CREATE INDEX vehicle_offer_content_history_uuid_index ON vehicle_offer_content_history (uuid);
CREATE INDEX vehicle_offer_content_history_updated_at_index ON vehicle_offer_content_history (updated_at);
CREATE INDEX vehicle_offer_content_history_created_at_index ON vehicle_offer_content_history (created_at);
CREATE TABLE IF NOT EXISTS "version_content" ("id" integer primary key autoincrement not null, "owner_type" varchar not null, "owner_id" integer not null, "parent_id" integer, "template_element_id" integer, "global_content_id" integer, "element_id" integer, "name" varchar, "slug" varchar, "content" text, "data" text, "order" integer not null default '0', "created_at" datetime, "updated_at" datetime);
CREATE INDEX "version_content_owner_type_owner_id_index" on "version_content" ("owner_type", "owner_id");
CREATE INDEX "version_content_updated_at_index" on "version_content" ("updated_at");
CREATE INDEX "version_content_parent_id_index" on "version_content" ("parent_id");
CREATE INDEX "version_content_template_element_id_index" on "version_content" ("template_element_id");
CREATE INDEX "version_content_global_content_id_index" on "version_content" ("global_content_id");
CREATE INDEX "version_content_element_id_index" on "version_content" ("element_id");
CREATE INDEX "version_content_order_index" on "version_content" ("order");
CREATE INDEX "pages_franchise_id_index" on "pages" ("franchise_id");
CREATE TABLE forms (id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, name VARCHAR(255) NOT NULL COLLATE "BINARY", type_id INTEGER DEFAULT NULL, is_active BOOLEAN DEFAULT NULL, active_from DATETIME DEFAULT NULL, active_until DATETIME DEFAULT NULL, data CLOB DEFAULT NULL COLLATE "BINARY", notify_customer_on_received_enquiry BOOLEAN DEFAULT 0 NOT NULL, customer_notification_subject VARCHAR(255) DEFAULT NULL COLLATE "BINARY", customer_notification_content CLOB DEFAULT NULL COLLATE "BINARY", success_message CLOB DEFAULT NULL COLLATE "BINARY", initial_status_id INTEGER DEFAULT NULL, initial_assignee INTEGER DEFAULT NULL, created_at DATETIME DEFAULT NULL, updated_at DATETIME DEFAULT NULL, deleted_at DATETIME DEFAULT NULL, "confirmation_message" text, "send_customer_confirmation_email" tinyint(1) not null default '1');
CREATE INDEX forms_initial_assignee_index ON forms (initial_assignee);
CREATE INDEX forms_initial_status_id_index ON forms (initial_status_id);
CREATE INDEX forms_active_until_index ON forms (active_until);
CREATE INDEX forms_active_from_index ON forms (active_from);
CREATE INDEX forms_is_active_index ON forms (is_active);
CREATE INDEX forms_type_id_index ON forms (type_id);
CREATE INDEX "vehicle_offer_content_slug_index" on "vehicle_offer_content" ("slug");
CREATE INDEX "media_external_index" on "media" ("external");
CREATE TABLE IF NOT EXISTS "labels" ("id" integer primary key autoincrement not null, "name" varchar not null, "type" varchar, "data" text, "created_at" datetime, "updated_at" datetime, "content" text, "franchise_id" integer, "category" varchar, "active" tinyint(1));
CREATE TABLE IF NOT EXISTS "vehicle_labels" ("id" integer primary key autoincrement not null, "vehicle_id" integer not null, "label_id" integer not null, "order" integer not null default '0', "created_at" datetime, "updated_at" datetime);
CREATE INDEX "vehicle_labels_vehicle_id_index" on "vehicle_labels" ("vehicle_id");
CREATE INDEX "vehicle_labels_label_id_index" on "vehicle_labels" ("label_id");
CREATE INDEX "vehicle_labels_order_index" on "vehicle_labels" ("order");
CREATE TABLE IF NOT EXISTS "vehicle_offer_labels" ("id" integer primary key autoincrement not null, "vehicle_offer_id" integer not null, "label_id" integer not null, "order" integer not null default '0', "created_at" datetime, "updated_at" datetime);
CREATE INDEX "vehicle_offer_labels_vehicle_offer_id_index" on "vehicle_offer_labels" ("vehicle_offer_id");
CREATE INDEX "vehicle_offer_labels_label_id_index" on "vehicle_offer_labels" ("label_id");
CREATE INDEX "vehicle_offer_labels_order_index" on "vehicle_offer_labels" ("order");
CREATE INDEX "vehicle_features_vehicle_id_index" on "vehicle_features" ("vehicle_id");
CREATE INDEX "settings_superadmin_index" on "settings" ("superadmin");
CREATE INDEX "enquiries_valuation_id_index" on "enquiries" ("valuation_id");
CREATE INDEX "vehicle_features_vehicle_type_vehicle_id_index" on "vehicle_features" ("vehicle_type", "vehicle_id");
CREATE INDEX "vehicle_features_vehicle_type_index" on "vehicle_features" ("vehicle_type");
CREATE TABLE IF NOT EXISTS "audits" ("id" integer primary key autoincrement not null, "user_type" varchar, "user_id" integer, "event" varchar not null, "auditable_type" varchar not null, "auditable_id" integer not null, "old_values" text, "new_values" text, "url" text, "ip_address" varchar, "user_agent" varchar, "tags" varchar, "created_at" datetime, "updated_at" datetime);
CREATE INDEX "audits_auditable_type_auditable_id_index" on "audits" ("auditable_type", "auditable_id");
CREATE INDEX "audits_user_id_user_type_index" on "audits" ("user_id", "user_type");
CREATE TABLE IF NOT EXISTS "conversions" ("id" integer primary key autoincrement not null, "owner_type" varchar not null, "owner_id" integer not null, "type" varchar not null, "date" date not null, "hits" integer not null default '0', "created_at" datetime, "updated_at" datetime);
CREATE INDEX "conversions_owner_type_owner_id_index" on "conversions" ("owner_type", "owner_id");
CREATE INDEX "conversions_type_index" on "conversions" ("type");
CREATE INDEX "conversions_date_index" on "conversions" ("date");
CREATE INDEX "media_last_used_index" on "media" ("last_used");
CREATE INDEX "media_uses_interior_index" on "media_uses" ("interior");
CREATE INDEX "media_uses_exterior_index" on "media_uses" ("exterior");
CREATE INDEX "media_uses_damages_index" on "media_uses" ("damages");
CREATE UNIQUE INDEX "media_unique_src" on "media" ("src", "image_provider");
CREATE TABLE IF NOT EXISTS "colour_mapping" ("id" integer primary key autoincrement not null, "colour_id" integer not null, "sub_colour" varchar not null, "created_at" datetime, "updated_at" datetime);
CREATE UNIQUE INDEX "colour_map_entry" on "colour_mapping" ("colour_id", "sub_colour");
CREATE INDEX "colour_mapping_sub_colour_index" on "colour_mapping" ("sub_colour");
CREATE UNIQUE INDEX "at_data_vehicle_id" on "vehicle_autotrader_data" ("vehicle_id");
CREATE TABLE colours (id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, colour VARCHAR(255) NOT NULL, hex_code VARCHAR(8) DEFAULT NULL, created_at DATETIME DEFAULT NULL, updated_at DATETIME DEFAULT NULL);
CREATE UNIQUE INDEX colours_colour_unique ON colours (colour);
CREATE TABLE IF NOT EXISTS "vehicle_attributes" ("id" integer primary key autoincrement not null, "name" varchar not null, "slug" varchar not null, "type" varchar not null, "validation" text, "count" integer not null default '1', "data" text, "order" integer not null default '0', "created_at" datetime, "updated_at" datetime);
CREATE INDEX "vehicle_attributes_name_index" on "vehicle_attributes" ("name");
CREATE INDEX "vehicle_attributes_slug_index" on "vehicle_attributes" ("slug");
CREATE INDEX "vehicle_attributes_type_index" on "vehicle_attributes" ("type");
CREATE INDEX "vehicle_attributes_order_index" on "vehicle_attributes" ("order");
CREATE TABLE IF NOT EXISTS "new_car_content" ("id" integer primary key autoincrement not null, "car_id" integer not null, "parent_id" integer, "template_element_id" integer, "global_content_id" integer, "element_id" integer, "slug" varchar, "name" varchar, "content" text, "search_content" text, "data" text, "order" integer not null default '0', "created_at" datetime, "updated_at" datetime, "hidden" tinyint(1));
CREATE INDEX "new_car_content_car_id_index" on "new_car_content" ("car_id");
CREATE INDEX "new_car_content_parent_id_index" on "new_car_content" ("parent_id");
CREATE INDEX "new_car_content_template_element_id_index" on "new_car_content" ("template_element_id");
CREATE INDEX "new_car_content_global_content_id_index" on "new_car_content" ("global_content_id");
CREATE INDEX "new_car_content_element_id_index" on "new_car_content" ("element_id");
CREATE INDEX "new_car_content_slug_index" on "new_car_content" ("slug");
CREATE INDEX "new_car_content_order_index" on "new_car_content" ("order");
CREATE TABLE IF NOT EXISTS "new_car_content_history" ("id" integer primary key autoincrement not null, "uuid" varchar not null, "car_id" integer not null, "author_id" integer, "is_active" tinyint(1) not null, "pending_review" tinyint(1), "request_changes" tinyint(1), "data" text, "content" text, "created_at" datetime, "updated_at" datetime, "deleted_at" datetime);
CREATE INDEX "new_car_content_history_uuid_index" on "new_car_content_history" ("uuid");
CREATE INDEX "new_car_content_history_car_id_index" on "new_car_content_history" ("car_id");
CREATE INDEX "new_car_content_history_author_id_index" on "new_car_content_history" ("author_id");
CREATE INDEX "new_car_content_history_is_active_index" on "new_car_content_history" ("is_active");
CREATE INDEX "new_car_content_history_pending_review_index" on "new_car_content_history" ("pending_review");
CREATE INDEX "new_car_content_history_request_changes_index" on "new_car_content_history" ("request_changes");
CREATE INDEX "new_car_content_history_deleted_at_index" on "new_car_content_history" ("deleted_at");
CREATE TABLE vehicle_offer_finance (id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, offer_id INTEGER NOT NULL, provider VARCHAR(255) DEFAULT NULL COLLATE "BINARY", finance_type VARCHAR(255) DEFAULT NULL COLLATE "BINARY", first_payment NUMERIC(10, 0) DEFAULT NULL, monthly_price NUMERIC(10, 0) DEFAULT NULL, final_payment NUMERIC(10, 0) DEFAULT NULL, full_price NUMERIC(10, 0) DEFAULT NULL, deposit NUMERIC(10, 0) DEFAULT NULL, total_amount NUMERIC(10, 0) DEFAULT NULL, total_credit_amount NUMERIC(10, 0) DEFAULT NULL, apr NUMERIC(10, 0) DEFAULT NULL, interest_rate NUMERIC(10, 0) DEFAULT NULL, number_of_payments INTEGER DEFAULT NULL, data CLOB DEFAULT NULL COLLATE "BINARY", created_at DATETIME DEFAULT NULL, updated_at DATETIME DEFAULT NULL, "annual_mileage" integer, "customer_deposit" numeric, "dealer_deposit_contribution" numeric, "option_to_purchase_fee" numeric, "excess_mileage_charge" numeric, "term" integer);
CREATE INDEX vehicle_offer_finance_offer_id_index ON vehicle_offer_finance (offer_id);
CREATE INDEX vehicle_offer_finance_provider_index ON vehicle_offer_finance (provider);
CREATE INDEX vehicle_offer_finance_type_index ON vehicle_offer_finance (finance_type);
CREATE TABLE IF NOT EXISTS "property_attribute_values" ("id" integer primary key autoincrement not null, "property_id" integer not null, "field_id" integer not null, "slug" varchar, "type" varchar, "value" varchar, "value_float" float, "value_datetime" datetime, "value_text" text, "order" integer not null default '0', "created_at" datetime, "updated_at" datetime);
CREATE INDEX "property_attribute_values_property_id_index" on "property_attribute_values" ("property_id");
CREATE INDEX "property_attribute_values_field_id_index" on "property_attribute_values" ("field_id");
CREATE INDEX "property_attribute_values_value_index" on "property_attribute_values" ("value");
CREATE INDEX "property_attribute_values_value_float_index" on "property_attribute_values" ("value_float");
CREATE INDEX "property_attribute_values_value_datetime_index" on "property_attribute_values" ("value_datetime");
CREATE INDEX "property_attribute_values_order_index" on "property_attribute_values" ("order");
CREATE TABLE IF NOT EXISTS "valuation_adjustments" ("id" integer primary key autoincrement not null, "is_active" tinyint(1), "is_increase" tinyint(1), "adjustment_amount" integer, "adjustment_type" varchar, "created_at" datetime, "updated_at" datetime);
CREATE INDEX "valuation_adjustments_is_active_index" on "valuation_adjustments" ("is_active");
CREATE INDEX "valuation_adjustments_is_increase_index" on "valuation_adjustments" ("is_increase");
CREATE TABLE IF NOT EXISTS "valuation_adjustment_rules" ("id" integer primary key autoincrement not null, "adjustment_id" integer not null, "column" varchar not null, "operator" varchar not null, "value" varchar not null, "created_at" datetime, "updated_at" datetime);
CREATE INDEX "valuation_adjustment_rules_adjustment_id_index" on "valuation_adjustment_rules" ("adjustment_id");
CREATE INDEX "valuation_adjustment_rules_column_index" on "valuation_adjustment_rules" ("column");
CREATE INDEX "valuation_adjustment_rules_value_index" on "valuation_adjustment_rules" ("value");
CREATE TABLE vehicle_attribute_values (id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, vehicle_id INTEGER NOT NULL, attribute_id INTEGER NOT NULL, slug VARCHAR(255) DEFAULT NULL, type VARCHAR(255) DEFAULT NULL, value VARCHAR(255) DEFAULT NULL, value_float DOUBLE PRECISION DEFAULT NULL, value_datetime DATETIME DEFAULT NULL, value_text CLOB DEFAULT NULL, "order" INTEGER DEFAULT 0 NOT NULL, "index" INTEGER DEFAULT 0 NOT NULL, created_at DATETIME DEFAULT NULL, updated_at DATETIME DEFAULT NULL, "value_integer" integer);
CREATE INDEX vehicle_attribute_values_index_index ON vehicle_attribute_values ("index");
CREATE INDEX vehicle_attribute_values_order_index ON vehicle_attribute_values ("order");
CREATE INDEX vehicle_attribute_values_value_datetime_index ON vehicle_attribute_values (value_datetime);
CREATE INDEX vehicle_attribute_values_value_float_index ON vehicle_attribute_values (value_float);
CREATE INDEX vehicle_attribute_values_value_index ON vehicle_attribute_values (value);
CREATE INDEX vehicle_attribute_values_attribute_id_index ON vehicle_attribute_values (attribute_id);
CREATE INDEX vehicle_attribute_values_vehicle_id_index ON vehicle_attribute_values (vehicle_id);
CREATE INDEX "vehicle_attribute_values_value_integer_index" on "vehicle_attribute_values" ("value_integer");
CREATE INDEX "sales_channel_history_vehicle_id_index" on "sales_channel_history" ("vehicle_id");
CREATE INDEX "media_sizes_model_index" on "media_sizes" ("model");
CREATE INDEX "dealerships_active_index" on "dealerships" ("active");
CREATE TABLE media_tags (id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, media_id INTEGER NOT NULL, tag VARCHAR(255) NOT NULL, created_at DATETIME DEFAULT NULL, updated_at DATETIME DEFAULT NULL);
CREATE INDEX media_tags_tag_index ON media_tags (tag);
CREATE INDEX media_tags_media_id_index ON media_tags (media_id);
CREATE INDEX "pages_deleted_at_idx" on "pages" ("deleted_at");
CREATE INDEX "page_versions_deleted_at_idx" on "page_versions" ("deleted_at");
CREATE INDEX "forms_deleted_at_idx" on "forms" ("deleted_at");
CREATE INDEX "enquiries_deleted_at_idx" on "enquiries" ("deleted_at");
CREATE UNIQUE INDEX "vehicle_features_unique_id_name" on "vehicle_features" ("vehicle_id", "vehicle_type", "name");
CREATE INDEX "settings_feature_index" on "settings" ("feature");
CREATE TABLE IF NOT EXISTS "api_notifications" ("id" integer primary key autoincrement not null, "provider" varchar not null, "processed" tinyint(1), "data_model" varchar, "reference" varchar, "headers" text, "data" text, "created_at" datetime, "updated_at" datetime);
CREATE INDEX "api_notifications_updated_at_index" on "api_notifications" ("updated_at");
CREATE INDEX "api_notifications_provider_index" on "api_notifications" ("provider");
CREATE INDEX "api_notifications_processed_index" on "api_notifications" ("processed");
CREATE INDEX "api_notifications_data_model_index" on "api_notifications" ("data_model");
CREATE INDEX "api_notifications_reference_index" on "api_notifications" ("reference");
CREATE TABLE vehicles (id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, slug VARCHAR(255) DEFAULT NULL, uuid VARCHAR(255) DEFAULT NULL, auto_trader_id VARCHAR(255) DEFAULT NULL, cap_id VARCHAR(255) DEFAULT NULL, vin VARCHAR(255) DEFAULT NULL, type VARCHAR(255) DEFAULT NULL, published_at DATETIME DEFAULT NULL, title VARCHAR(255) DEFAULT NULL, derivative VARCHAR(255) DEFAULT NULL, registration_number VARCHAR(255) DEFAULT NULL, personalized_number_plate BOOLEAN DEFAULT NULL, is_new BOOLEAN DEFAULT NULL, featured BOOLEAN DEFAULT 0 NOT NULL, make_id INTEGER DEFAULT NULL, model_id INTEGER DEFAULT NULL, transmission_id INTEGER DEFAULT NULL, fuel_type_id INTEGER DEFAULT NULL, body_style_id INTEGER DEFAULT NULL, drivetrain_id INTEGER DEFAULT NULL, dealership_id INTEGER DEFAULT NULL, colour VARCHAR(255) DEFAULT NULL, price NUMERIC(10, 2) DEFAULT NULL, monthly_price NUMERIC(10, 0) DEFAULT NULL, deposit NUMERIC(10, 0) DEFAULT NULL, door_count INTEGER DEFAULT NULL, seats INTEGER DEFAULT NULL, manufacture_year INTEGER DEFAULT NULL, odometer_km INTEGER DEFAULT NULL, odometer_mi INTEGER DEFAULT NULL, engine_size_cc INTEGER DEFAULT NULL, co2 INTEGER DEFAULT NULL, mpg NUMERIC(10, 0) DEFAULT NULL, previous_owner_count INTEGER DEFAULT NULL, first_registration_date DATE DEFAULT NULL, description CLOB DEFAULT NULL, data CLOB DEFAULT NULL, exterior_video_url VARCHAR(255) DEFAULT NULL, interior_video_url VARCHAR(255) DEFAULT NULL, search_content CLOB DEFAULT NULL, created_at DATETIME DEFAULT NULL, updated_at DATETIME DEFAULT NULL, deleted_at DATETIME DEFAULT NULL, is_published BOOLEAN DEFAULT 0 NOT NULL, is_reserved BOOLEAN DEFAULT 0 NOT NULL, is_sold BOOLEAN DEFAULT 0 NOT NULL, is_demo BOOLEAN DEFAULT 0 NOT NULL, stock_provider VARCHAR(255) DEFAULT NULL, battery_range INTEGER DEFAULT NULL, battery_capacity_kwh INTEGER DEFAULT NULL, battery_usable_capacity_kwh INTEGER DEFAULT NULL, battery_charge_time INTEGER DEFAULT NULL, battery_quick_charge_time INTEGER DEFAULT NULL, original_price NUMERIC(10, 2) DEFAULT NULL, rrp_price NUMERIC(10, 2) DEFAULT NULL, main_video_url VARCHAR(255) DEFAULT NULL, available_date DATETIME DEFAULT NULL, monthly_cost_type VARCHAR(255) DEFAULT NULL, archived_at DATETIME DEFAULT NULL, stock_arrival_date DATETIME DEFAULT NULL, is_vat_applicable BOOLEAN DEFAULT 1 NOT NULL, was_recently_synced BOOLEAN DEFAULT NULL, wheelbase_type VARCHAR(255) DEFAULT NULL, wheelbase_mm INTEGER DEFAULT NULL, payload_kg INTEGER DEFAULT NULL, gross_vehicle_weight_kg NUMERIC(10, 0) DEFAULT NULL, bhp NUMERIC(10, 0) DEFAULT NULL, previous_price NUMERIC(10, 2) DEFAULT NULL, "pending_stock_sync" tinyint(1), "attention_grabber" varchar, "lat" numeric, "lng" numeric, "trim" varchar, "admin_fee" numeric, "battery_quick_charge_level" integer, "vehicle_length" integer, "vrm_condensed" varchar);
CREATE INDEX vehicles_created_at_index ON vehicles (created_at);
CREATE INDEX vehicles_deleted_at_idx ON vehicles (deleted_at);
CREATE INDEX vehicles_was_recently_synced_index ON vehicles (was_recently_synced);
CREATE INDEX vehicles_is_vat_applicable_index ON vehicles (is_vat_applicable);
CREATE INDEX vehicles_stock_arrival_date_index ON vehicles (stock_arrival_date);
CREATE INDEX vehicles_archived_at_index ON vehicles (archived_at);
CREATE INDEX vehicles_stock_provider_index ON vehicles (stock_provider);
CREATE INDEX vehicles_is_demo_index ON vehicles (is_demo);
CREATE INDEX vehicles_is_sold_index ON vehicles (is_sold);
CREATE INDEX vehicles_is_reserved_index ON vehicles (is_reserved);
CREATE INDEX vehicles_is_published_index ON vehicles (is_published);
CREATE INDEX vehicles_mpg_index ON vehicles (mpg);
CREATE INDEX vehicles_co2_index ON vehicles (co2);
CREATE INDEX vehicles_engine_size_cc_index ON vehicles (engine_size_cc);
CREATE INDEX vehicles_odometer_mi_index ON vehicles (odometer_mi);
CREATE INDEX vehicles_odometer_km_index ON vehicles (odometer_km);
CREATE INDEX vehicles_manufacture_year_index ON vehicles (manufacture_year);
CREATE INDEX vehicles_seats_index ON vehicles (seats);
CREATE INDEX vehicles_door_count_index ON vehicles (door_count);
CREATE INDEX vehicles_deposit_index ON vehicles (deposit);
CREATE INDEX vehicles_monthly_price_index ON vehicles (monthly_price);
CREATE INDEX vehicles_price_index ON vehicles (price);
CREATE INDEX vehicles_colour_index ON vehicles (colour);
CREATE INDEX vehicles_dealership_id_index ON vehicles (dealership_id);
CREATE INDEX vehicles_drivetrain_id_index ON vehicles (drivetrain_id);
CREATE INDEX vehicles_body_style_id_index ON vehicles (body_style_id);
CREATE INDEX vehicles_fuel_type_id_index ON vehicles (fuel_type_id);
CREATE INDEX vehicles_transmission_id_index ON vehicles (transmission_id);
CREATE INDEX vehicles_model_id_index ON vehicles (model_id);
CREATE INDEX vehicles_make_id_index ON vehicles (make_id);
CREATE INDEX vehicles_featured_index ON vehicles (featured);
CREATE INDEX vehicles_is_new_index ON vehicles (is_new);
CREATE INDEX vehicles_registration_number_index ON vehicles (registration_number);
CREATE INDEX vehicles_derivative_index ON vehicles (derivative);
CREATE INDEX vehicles_title_index ON vehicles (title);
CREATE INDEX vehicles_type_index ON vehicles (type);
CREATE INDEX vehicles_vin_index ON vehicles (vin);
CREATE INDEX vehicles_cap_id_index ON vehicles (cap_id);
CREATE INDEX vehicles_auto_trader_id_index ON vehicles (auto_trader_id);
CREATE INDEX vehicles_uuid_index ON vehicles (uuid);
CREATE INDEX vehicles_slug_index ON vehicles (slug);
CREATE INDEX "dealerships_franchise_id_index" on "dealerships" ("franchise_id");
CREATE INDEX "menus_franchise_id_index" on "menus" ("franchise_id");
CREATE TABLE IF NOT EXISTS "label_rules" ("id" integer primary key autoincrement not null, "label_id" integer not null, "condition_field" varchar not null, "condition_value" text, "value_data_type" varchar, "created_at" datetime, "updated_at" datetime);
CREATE INDEX "label_rules_label_id_index" on "label_rules" ("label_id");
CREATE INDEX "label_rules_condition_field_index" on "label_rules" ("condition_field");
CREATE INDEX "vehicles_pending_stock_sync_index" on "vehicles" ("pending_stock_sync");
CREATE UNIQUE INDEX "unique_vehicle_attribute_value" on "vehicle_attribute_values" ("vehicle_id", "attribute_id", "index");
CREATE TABLE IF NOT EXISTS "page_categories" ("id" integer primary key autoincrement not null, "page_id" integer not null, "category_id" integer not null, "created_at" datetime, "updated_at" datetime);
CREATE INDEX "page_categories_page_id_category_id_index" on "page_categories" ("page_id", "category_id");
CREATE TABLE IF NOT EXISTS "page_tags" ("id" integer primary key autoincrement not null, "page_id" integer not null, "tag_id" integer not null, "created_at" datetime, "updated_at" datetime);
CREATE INDEX "page_tags_page_id_tag_id_index" on "page_tags" ("page_id", "tag_id");
CREATE INDEX "vehicles_lat_index" on "vehicles" ("lat");
CREATE INDEX "vehicles_lng_index" on "vehicles" ("lng");
CREATE TABLE vehicle_standard_equipment (id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, vehicle_id INTEGER NOT NULL, type VARCHAR(255) DEFAULT NULL, code VARCHAR(255) DEFAULT NULL, description VARCHAR(500) DEFAULT NULL, category VARCHAR(255) DEFAULT NULL, price NUMERIC(10, 0) DEFAULT NULL, vat_amount NUMERIC(10, 0) DEFAULT NULL, created_at DATETIME DEFAULT NULL, updated_at DATETIME DEFAULT NULL, feature_id INTEGER DEFAULT NULL, vehicle_type VARCHAR(255) DEFAULT NULL);
CREATE UNIQUE INDEX vehicle_standard_equipment_unique_fields ON vehicle_standard_equipment (vehicle_id, vehicle_type, category, description);
CREATE UNIQUE INDEX vehicle_standard_equipment_unique_id_description ON vehicle_standard_equipment (vehicle_id, vehicle_type, description);
CREATE INDEX vehicle_standard_equipment_vehicle_type_index ON vehicle_standard_equipment (vehicle_type);
CREATE INDEX vehicle_standard_equipment_vehicle_type_vehicle_id_index ON vehicle_standard_equipment (vehicle_type, vehicle_id);
CREATE INDEX vehicle_standard_equipment_category_index ON vehicle_standard_equipment (category);
CREATE INDEX vehicle_standard_equipment_code_index ON vehicle_standard_equipment (code);
CREATE INDEX vehicle_standard_equipment_type_index ON vehicle_standard_equipment (type);
CREATE INDEX vehicle_standard_equipment_vehicle_id_index ON vehicle_standard_equipment (vehicle_id);
CREATE TABLE vehicle_tech_data (id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, vehicle_id BIGINT UNSIGNED NOT NULL, code VARCHAR(255) DEFAULT NULL, description VARCHAR(255) NOT NULL, value VARCHAR(500) NOT NULL, category VARCHAR(255) DEFAULT NULL, created_at DATETIME DEFAULT NULL, updated_at DATETIME DEFAULT NULL, vehicle_type VARCHAR(255) DEFAULT NULL);
CREATE UNIQUE INDEX vehicle_tech_data_unique_fields ON vehicle_tech_data (vehicle_id, vehicle_type, category, description);
CREATE UNIQUE INDEX vehicle_tech_data_unique_id_description ON vehicle_tech_data (vehicle_id, vehicle_type, description);
CREATE INDEX vehicle_tech_data_vehicle_type_index ON vehicle_tech_data (vehicle_type);
CREATE INDEX vehicle_tech_data_vehicle_type_vehicle_id_index ON vehicle_tech_data (vehicle_type, vehicle_id);
CREATE INDEX vehicle_tech_data_vehicle_id_index ON vehicle_tech_data (vehicle_id);
CREATE INDEX vehicle_tech_data_code_index ON vehicle_tech_data (code);
CREATE INDEX vehicle_tech_data_description_index ON vehicle_tech_data (description);
CREATE INDEX vehicle_tech_data_value_index ON vehicle_tech_data (value);
CREATE INDEX vehicle_tech_data_category_index ON vehicle_tech_data (category);
CREATE TABLE IF NOT EXISTS "service_bookings" ("id" integer primary key autoincrement not null, "uuid" varchar not null, "customer_id" integer, "registration_number" varchar not null, "mileage" integer not null, "email" varchar, "phone_number" varchar, "first_name" varchar, "last_name" varchar, "booking_time" datetime, "location_id" integer, "vehicle_data" text, "data" text, "notes" varchar, "delivery_option_id" integer, "status" varchar not null default 'pending', "created_at" datetime, "updated_at" datetime, "ingested_at" datetime);
CREATE INDEX "service_bookings_uuid_index" on "service_bookings" ("uuid");
CREATE INDEX "service_bookings_registration_number_index" on "service_bookings" ("registration_number");
CREATE INDEX "service_bookings_email_index" on "service_bookings" ("email");
CREATE INDEX "service_bookings_phone_number_index" on "service_bookings" ("phone_number");
CREATE INDEX "service_bookings_booking_time_index" on "service_bookings" ("booking_time");
CREATE INDEX "service_bookings_location_id_index" on "service_bookings" ("location_id");
CREATE INDEX "service_bookings_status_index" on "service_bookings" ("status");
CREATE TABLE IF NOT EXISTS "service_booking_packages" ("id" integer primary key autoincrement not null, "booking_id" integer not null, "package_id" integer not null, "created_at" datetime, "updated_at" datetime);
CREATE INDEX "service_booking_packages_booking_id_index" on "service_booking_packages" ("booking_id");
CREATE INDEX "service_booking_packages_package_id_index" on "service_booking_packages" ("package_id");
CREATE TABLE IF NOT EXISTS "service_packages" ("id" integer primary key autoincrement not null, "applicable_make_id" integer, "applicable_model_id" integer, "type" varchar not null, "name" varchar not null, "price" numeric, "description" text, "created_at" datetime, "updated_at" datetime);
CREATE INDEX "service_packages_applicable_make_id_index" on "service_packages" ("applicable_make_id");
CREATE INDEX "service_packages_applicable_model_id_index" on "service_packages" ("applicable_model_id");
CREATE INDEX "service_packages_type_index" on "service_packages" ("type");
CREATE TABLE IF NOT EXISTS "service_delivery_options" ("id" integer primary key autoincrement not null, "name" varchar not null, "description" text, "price" numeric, "created_at" datetime, "updated_at" datetime);
CREATE INDEX "page_content_hidden_index" on "page_content" ("hidden");
CREATE INDEX "vehicle_offer_content_hidden_index" on "vehicle_offer_content" ("hidden");
CREATE INDEX "new_car_content_hidden_index" on "new_car_content" ("hidden");
CREATE INDEX "media_created_at" on "media" ("created_at");
CREATE INDEX "media_updated_at" on "media" ("updated_at");
CREATE INDEX "media_uses_created_at" on "media_uses" ("created_at");
CREATE INDEX "media_uses_updated_at" on "media_uses" ("updated_at");
CREATE INDEX "media_uses_order" on "media_uses" ("order");
CREATE TABLE content_categories (id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, name VARCHAR(255) DEFAULT NULL, slug VARCHAR(255) DEFAULT NULL, created_at DATETIME DEFAULT NULL, updated_at DATETIME DEFAULT NULL);
CREATE TABLE content_tags (id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, name VARCHAR(255) DEFAULT NULL, slug VARCHAR(255) DEFAULT NULL, created_at DATETIME DEFAULT NULL, updated_at DATETIME DEFAULT NULL);
CREATE TABLE IF NOT EXISTS "search_index" ("id" integer primary key autoincrement not null, "filter_type" varchar not null, "filter_id" varchar not null, "name" varchar, "slug" varchar, "num_results" integer, "selection_hash" varchar, "created_at" datetime, "updated_at" datetime);
CREATE INDEX "search_index_filter_object" on "search_index" ("filter_type", "filter_id");
CREATE INDEX "search_index_slug_index" on "search_index" ("slug");
CREATE INDEX "search_index_selection_hash_index" on "search_index" ("selection_hash");
CREATE TABLE IF NOT EXISTS "service_location_availability" ("id" integer primary key autoincrement not null, "dealership_id" integer not null, "active" tinyint(1), "number_of_bays" integer not null, "time_windows" text, "mondays" tinyint(1), "tuesdays" tinyint(1), "wednesdays" tinyint(1), "thursdays" tinyint(1), "fridays" tinyint(1), "saturdays" tinyint(1), "sundays" tinyint(1), "created_at" datetime, "updated_at" datetime, "min_days_in_future_for_booking" integer default '0', "max_days_in_future_for_booking" integer default '90', "email" varchar);
CREATE INDEX "service_location_availability_dealership_id_index" on "service_location_availability" ("dealership_id");
CREATE INDEX "service_location_availability_active_index" on "service_location_availability" ("active");
CREATE TABLE IF NOT EXISTS "service_location_availability_holidays" ("id" integer primary key autoincrement not null, "availability_id" integer not null, "holiday_date" date not null, "note" varchar, "created_at" datetime, "updated_at" datetime);
CREATE INDEX "service_location_availability_holidays_availability_id_index" on "service_location_availability_holidays" ("availability_id");
CREATE INDEX "service_location_availability_holidays_holiday_date_index" on "service_location_availability_holidays" ("holiday_date");
CREATE TABLE vehicle_finance (id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, vehicle_id INTEGER NOT NULL, provider VARCHAR(255) NOT NULL, finance_type VARCHAR(255) NOT NULL, term SMALLINT DEFAULT NULL --term length in months
, number_of_payments SMALLINT DEFAULT NULL --number of monthly payments
, monthly_price NUMERIC(12, 2) DEFAULT NULL, first_payment NUMERIC(12, 2) DEFAULT NULL, final_payment NUMERIC(12, 2) DEFAULT NULL, total_deposit NUMERIC(12, 2) DEFAULT NULL, interest_rate NUMERIC(8, 2) DEFAULT NULL, apr NUMERIC(8, 2) DEFAULT NULL, apply_url VARCHAR(255) DEFAULT NULL, created_at DATETIME DEFAULT NULL, updated_at DATETIME DEFAULT NULL, total_credit_amount NUMERIC(12, 2) DEFAULT NULL, annual_mileage INTEGER DEFAULT NULL, cash_price NUMERIC(12, 2) DEFAULT NULL, dealer_deposit NUMERIC(12, 2) DEFAULT NULL, customer_deposit NUMERIC(12, 2) DEFAULT NULL, payable_amount NUMERIC(12, 2) DEFAULT NULL, option_to_purchase_fee NUMERIC(12, 2) DEFAULT NULL, documentation_fee NUMERIC(12, 2) DEFAULT NULL, "terms_and_conditions" text);
CREATE INDEX vehicle_finance_vehicle_id_index ON vehicle_finance (vehicle_id);
CREATE INDEX "form_questions_segment_index" on "form_questions" ("segment");
CREATE TABLE IF NOT EXISTS "replacements" ("id" integer primary key autoincrement not null, "original" varchar not null, "replacement" varchar, "type" varchar not null default 'global', "created_at" datetime, "updated_at" datetime);
CREATE INDEX "filter_index_slug" on "filter_index" ("slug");
CREATE TABLE IF NOT EXISTS "media_folders" ("id" integer primary key autoincrement not null, "_lft" integer not null default '0', "_rgt" integer not null default '0', "parent_id" integer, "name" varchar not null, "created_at" datetime, "updated_at" datetime, "order" integer not null default '0');
CREATE INDEX "media_folders__lft__rgt_parent_id_index" on "media_folders" ("_lft", "_rgt", "parent_id");
CREATE INDEX "media_folder_id_index" on "media" ("folder_id");
CREATE INDEX "dealerships_lat_lng_index" on "dealerships" ("lat", "lng");
CREATE TABLE IF NOT EXISTS "catalog_offers" ("id" integer primary key autoincrement not null, "name" varchar not null, "subtitle" varchar, "link" varchar, "button_text" varchar, "active" tinyint(1) not null default '1', "created_at" datetime, "updated_at" datetime);
CREATE INDEX "pages_featured_index" on "pages" ("featured");
CREATE INDEX "labels_franchise_id_index" on "labels" ("franchise_id");
CREATE TABLE IF NOT EXISTS "reservations" ("id" integer primary key autoincrement not null, "vehicle_id" integer not null, "customer_id" integer, "reference" varchar not null, "status" varchar not null, "amount" numeric, "amount_ex_vat" numeric, "vat_value" numeric, "amount_in_currency" numeric, "currency" varchar, "email" varchar, "name" varchar, "contact_number" varchar, "data" text, "confirmed_at" datetime, "confirmation_sent_at" datetime, "created_at" datetime, "updated_at" datetime, "ingested_at" datetime, "attempts" integer not null default '0');
CREATE INDEX "reservations_vehicle_id_index" on "reservations" ("vehicle_id");
CREATE INDEX "reservations_customer_id_index" on "reservations" ("customer_id");
CREATE INDEX "reservations_reference_index" on "reservations" ("reference");
CREATE INDEX "reservations_status_index" on "reservations" ("status");
CREATE INDEX "reservations_email_index" on "reservations" ("email");
CREATE INDEX "reservations_name_index" on "reservations" ("name");
CREATE INDEX "reservations_contact_number_index" on "reservations" ("contact_number");
CREATE INDEX "reservations_confirmed_at_index" on "reservations" ("confirmed_at");
CREATE INDEX "reservations_confirmation_sent_at_index" on "reservations" ("confirmation_sent_at");
CREATE TABLE valuations (id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, user_id INTEGER DEFAULT NULL, provider VARCHAR(255) NOT NULL COLLATE "BINARY", registration VARCHAR(255) NOT NULL COLLATE "BINARY", mileage INTEGER NOT NULL, vehicle_type VARCHAR(20) DEFAULT NULL COLLATE "BINARY", make VARCHAR(255) DEFAULT NULL COLLATE "BINARY", model VARCHAR(255) DEFAULT NULL COLLATE "BINARY", derivative VARCHAR(255) DEFAULT NULL COLLATE "BINARY", fuel_type VARCHAR(255) DEFAULT NULL COLLATE "BINARY", engine_size VARCHAR(255) DEFAULT NULL COLLATE "BINARY", body_type VARCHAR(255) DEFAULT NULL COLLATE "BINARY", transmission VARCHAR(255) DEFAULT NULL COLLATE "BINARY", date_of_registration DATE DEFAULT NULL, valuation_made_at DATETIME DEFAULT NULL, retail_price NUMERIC(10, 0) DEFAULT NULL, average_price NUMERIC(10, 0) DEFAULT NULL, clean_price NUMERIC(10, 0) DEFAULT NULL, below_price NUMERIC(10, 0) DEFAULT NULL, errors CLOB DEFAULT NULL COLLATE "BINARY", created_at DATETIME DEFAULT NULL, updated_at DATETIME DEFAULT NULL, adjustment_id INTEGER DEFAULT NULL, adjusted_retail_price NUMERIC(10, 0) DEFAULT NULL, colour VARCHAR(255) DEFAULT NULL COLLATE "BINARY", "valuation_id" varchar);
CREATE INDEX valuations_adjustment_id_index ON valuations (adjustment_id);
CREATE INDEX valuations_created_at_index ON valuations (created_at);
CREATE INDEX valuations_user_id_index ON valuations (user_id);
CREATE INDEX valuations_provider_index ON valuations (provider);
CREATE INDEX valuations_registration_index ON valuations (registration);
CREATE INDEX valuations_mileage_index ON valuations (mileage);
CREATE INDEX valuations_valuation_made_at_index ON valuations (valuation_made_at);
CREATE INDEX "labels_active_index" on "labels" ("active");
CREATE INDEX "vehicles_trim_index" on "vehicles" ("trim");
CREATE TABLE IF NOT EXISTS "vehicle_trims" ("id" integer primary key autoincrement not null, "name" varchar not null, "make_id" integer, "created_at" datetime, "updated_at" datetime, "active" tinyint(1) not null default '1', "model_id" integer, "fuel_types" text, "colours" text, "transmission_types" text, "mpg" numeric, "emissions" numeric, "engine_size" numeric, "bhp" numeric, "zero_to_sixty" numeric, "doors" integer, "seats" integer, "battery_size" numeric, "range_miles" numeric, "battery_charge_time" integer, "battery_quick_charge_time" integer, "wheelbase" varchar, "description" text);
CREATE INDEX "vehicle_trims_make_id_index" on "vehicle_trims" ("make_id");
CREATE INDEX "reservations_ingested_at_index" on "reservations" ("ingested_at");
CREATE TABLE IF NOT EXISTS "invoices" ("id" integer primary key autoincrement not null, "payable_type" varchar not null, "payable_id" integer not null, "reference" varchar not null, "customer_id" integer, "name" varchar, "email" varchar, "contact_number" varchar, "status" integer not null default '0', "amount" numeric, "amount_ex_vat" numeric, "amount_in_currency" numeric, "currency" varchar not null, "outstanding_amount" numeric, "outstanding_amount_ex_vat" numeric, "vat_value" numeric, "use_ex_vat" tinyint(1) not null default '0', "details" text, "due_at" date, "template" varchar, "invite_emails_sent" integer not null default '0', "last_payment_invite_email" datetime, "created_at" datetime, "updated_at" datetime);
CREATE INDEX "invoices_payable_type_payable_id_index" on "invoices" ("payable_type", "payable_id");
CREATE INDEX "invoices_reference_index" on "invoices" ("reference");
CREATE INDEX "invoices_customer_id_index" on "invoices" ("customer_id");
CREATE INDEX "invoices_name_index" on "invoices" ("name");
CREATE INDEX "invoices_email_index" on "invoices" ("email");
CREATE INDEX "invoices_status_index" on "invoices" ("status");
CREATE INDEX "invoices_currency_index" on "invoices" ("currency");
CREATE INDEX "invoices_outstanding_amount_index" on "invoices" ("outstanding_amount");
CREATE TABLE IF NOT EXISTS "invoice_items" ("id" integer primary key autoincrement not null, "invoice_id" integer, "purchasable_id" integer, "parent_type" varchar, "parent_id" integer, "purchasable_type" varchar, "name" varchar, "value" numeric, "value_ex_vat" numeric, "original_value" numeric, "original_value_ex_vat" numeric, "quantity" integer not null, "line_total" numeric, "line_total_ex_vat" numeric, "vat_rate" varchar, "details" text, "created_at" datetime, "updated_at" datetime, "deleted_at" datetime);
CREATE INDEX "invoice_items_parent_type_parent_id_index" on "invoice_items" ("parent_type", "parent_id");
CREATE INDEX "invoice_items_purchasable_id_purchasable_type_index" on "invoice_items" ("purchasable_id", "purchasable_type");
CREATE INDEX "invoice_items_invoice_id_index" on "invoice_items" ("invoice_id");
CREATE TABLE IF NOT EXISTS "invoice_lines" ("id" integer primary key autoincrement not null, "invoice_id" integer, "parent_type" varchar, "parent_id" integer, "type" varchar not null, "name" varchar not null, "is_negative" tinyint(1), "value" numeric, "value_ex_vat" numeric, "created_at" datetime, "updated_at" datetime);
CREATE INDEX "invoice_lines_parent_type_parent_id_index" on "invoice_lines" ("parent_type", "parent_id");
CREATE INDEX "invoice_lines_invoice_id_index" on "invoice_lines" ("invoice_id");
CREATE INDEX "invoice_lines_type_index" on "invoice_lines" ("type");
CREATE INDEX "invoice_lines_is_negative_index" on "invoice_lines" ("is_negative");
CREATE TABLE IF NOT EXISTS "invoice_payments" ("id" integer primary key autoincrement not null, "invoice_id" integer, "provider" varchar not null, "amount" numeric not null, "currency_code" varchar, "amount_in_currency" numeric, "failed_at" datetime, "failure_details" text, "reference" varchar not null, "confirmed_at" datetime, "details" text, "created_at" datetime, "updated_at" datetime);
CREATE INDEX "invoice_payments_invoice_id_index" on "invoice_payments" ("invoice_id");
CREATE INDEX "invoice_payments_provider_index" on "invoice_payments" ("provider");
CREATE INDEX "invoice_payments_currency_code_index" on "invoice_payments" ("currency_code");
CREATE INDEX "invoice_payments_failed_at_index" on "invoice_payments" ("failed_at");
CREATE INDEX "invoice_payments_reference_index" on "invoice_payments" ("reference");
CREATE INDEX "invoice_payments_confirmed_at_index" on "invoice_payments" ("confirmed_at");
CREATE TABLE IF NOT EXISTS "invoice_addresses" ("id" integer primary key autoincrement not null, "invoice_id" integer, "type" varchar not null, "title" varchar, "first_name" varchar, "last_name" varchar, "address1" varchar, "address2" varchar, "city" varchar, "county" varchar, "postcode" varchar, "country" varchar, "state" varchar, "created_at" datetime, "updated_at" datetime);
CREATE INDEX "invoice_addresses_invoice_id_index" on "invoice_addresses" ("invoice_id");
CREATE INDEX "invoice_addresses_type_index" on "invoice_addresses" ("type");
CREATE TABLE IF NOT EXISTS "reservation_statuses" ("id" integer primary key autoincrement not null, "name" varchar not null, "is_final" tinyint(1) not null default '0', "is_initial" tinyint(1) not null default '0', "is_editable" tinyint(1) not null default '1', "created_at" datetime, "updated_at" datetime);
CREATE INDEX "vehicle_trims_active_index" on "vehicle_trims" ("active");
CREATE INDEX "vehicle_trims_model_id_index" on "vehicle_trims" ("model_id");
CREATE INDEX "vehicle_trims_doors_index" on "vehicle_trims" ("doors");
CREATE INDEX "vehicle_trims_seats_index" on "vehicle_trims" ("seats");
CREATE INDEX "vehicle_trims_battery_charge_time_index" on "vehicle_trims" ("battery_charge_time");
CREATE INDEX "vehicle_trims_battery_quick_charge_time_index" on "vehicle_trims" ("battery_quick_charge_time");
CREATE INDEX "dealerships_template_id_index" on "dealerships" ("template_id");
CREATE TABLE IF NOT EXISTS "dealership_content" ("id" integer primary key autoincrement not null, "dealership_id" integer not null, "parent_id" integer, "template_element_id" integer, "global_content_id" integer, "element_id" integer, "name" varchar, "content" text, "search_content" text, "data" text, "order" integer not null default '0', "slug" varchar, "hidden" tinyint(1), "created_at" datetime, "updated_at" datetime);
CREATE INDEX "dealership_content_dealership_id_index" on "dealership_content" ("dealership_id");
CREATE INDEX "dealership_content_parent_id_index" on "dealership_content" ("parent_id");
CREATE INDEX "dealership_content_template_element_id_index" on "dealership_content" ("template_element_id");
CREATE INDEX "dealership_content_global_content_id_index" on "dealership_content" ("global_content_id");
CREATE INDEX "dealership_content_element_id_index" on "dealership_content" ("element_id");
CREATE INDEX "dealership_content_order_index" on "dealership_content" ("order");
CREATE INDEX "dealership_content_slug_index" on "dealership_content" ("slug");
CREATE INDEX "dealership_content_hidden_index" on "dealership_content" ("hidden");
CREATE TABLE IF NOT EXISTS "dealership_content_history" ("id" integer primary key autoincrement not null, "uuid" varchar not null, "dealership_id" integer not null, "author_id" integer, "is_active" tinyint(1) not null, "data" text, "created_at" datetime, "updated_at" datetime, "pending_review" tinyint(1), "request_changes" tinyint(1), "deleted_at" datetime);
CREATE INDEX "dealership_content_history_created_at_index" on "dealership_content_history" ("created_at");
CREATE INDEX "dealership_content_history_updated_at_index" on "dealership_content_history" ("updated_at");
CREATE INDEX "dealership_content_history_uuid_index" on "dealership_content_history" ("uuid");
CREATE INDEX "dealership_content_history_dealership_id_index" on "dealership_content_history" ("dealership_id");
CREATE INDEX "dealership_content_history_author_id_index" on "dealership_content_history" ("author_id");
CREATE INDEX "dealership_content_history_is_active_index" on "dealership_content_history" ("is_active");
CREATE INDEX "dealership_content_history_pending_review_index" on "dealership_content_history" ("pending_review");
CREATE INDEX "dealership_content_history_request_changes_index" on "dealership_content_history" ("request_changes");
CREATE INDEX "dealership_content_history_deleted_at_index" on "dealership_content_history" ("deleted_at");
CREATE TABLE vehicle_offers (id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, name VARCHAR(255) NOT NULL, slug VARCHAR(255) DEFAULT NULL, status VARCHAR(255) DEFAULT NULL, featured BOOLEAN DEFAULT 0 NOT NULL, derivative VARCHAR(255) DEFAULT NULL, template_id INTEGER DEFAULT NULL, dealership_id INTEGER DEFAULT NULL, make_id INTEGER DEFAULT NULL, model_id INTEGER DEFAULT NULL, form_id INTEGER DEFAULT NULL, price NUMERIC(10, 0) DEFAULT NULL, deposit NUMERIC(10, 0) DEFAULT NULL, published_at DATETIME DEFAULT NULL, seo CLOB DEFAULT NULL, data CLOB DEFAULT NULL, search_content CLOB DEFAULT NULL, created_at DATETIME DEFAULT NULL, updated_at DATETIME DEFAULT NULL, deleted_at DATETIME DEFAULT NULL, published BOOLEAN DEFAULT 0 NOT NULL, type VARCHAR(255) DEFAULT NULL, type_id INTEGER DEFAULT NULL, battery_range INTEGER DEFAULT NULL, battery_capacity_kwh INTEGER DEFAULT NULL, battery_usable_capacity_kwh INTEGER DEFAULT NULL, battery_charge_time INTEGER DEFAULT NULL, battery_quick_charge_time INTEGER DEFAULT NULL, franchise_id INTEGER DEFAULT NULL, transmission_id INTEGER DEFAULT NULL, fuel_type_id INTEGER DEFAULT NULL, body_style_id INTEGER DEFAULT NULL, drivetrain_id INTEGER DEFAULT NULL, engine_size_cc INTEGER DEFAULT NULL, colour VARCHAR(255) DEFAULT NULL, uuid VARCHAR(255) DEFAULT NULL, stock_provider VARCHAR(255) DEFAULT NULL, vin VARCHAR(255) DEFAULT NULL, new_car_type VARCHAR(255) DEFAULT NULL, trim VARCHAR(255) DEFAULT NULL, mpg NUMERIC(10, 0) DEFAULT NULL, key_features CLOB DEFAULT NULL, description CLOB DEFAULT NULL, standard_spec CLOB DEFAULT NULL, technical_spec CLOB DEFAULT NULL, youtube_video VARCHAR(255) DEFAULT NULL, t_and_cs CLOB DEFAULT NULL, excerpt CLOB DEFAULT NULL, label VARCHAR(255) DEFAULT NULL, cta_button1_label VARCHAR(255) DEFAULT NULL, cta_button1_url VARCHAR(255) DEFAULT NULL, cta_button2_label VARCHAR(255) DEFAULT NULL, cta_button2_url VARCHAR(255) DEFAULT NULL, footnote CLOB DEFAULT NULL, "co2" numeric, "battery_quick_charge_level" integer, "auto_trader_id" varchar, "cap_id" varchar);
CREATE INDEX vehicle_offers_trim_index ON vehicle_offers (trim);
CREATE INDEX vehicle_offers_new_car_type_index ON vehicle_offers (new_car_type);
CREATE INDEX vehicle_offers_vin_index ON vehicle_offers (vin);
CREATE INDEX vehicle_offers_stock_provider_index ON vehicle_offers (stock_provider);
CREATE INDEX vehicle_offers_uuid_index ON vehicle_offers (uuid);
CREATE INDEX vehicle_offers_deleted_at_idx ON vehicle_offers (deleted_at);
CREATE INDEX vehicle_offers_colour_index ON vehicle_offers (colour);
CREATE INDEX vehicle_offers_engine_size_cc_index ON vehicle_offers (engine_size_cc);
CREATE INDEX vehicle_offers_drivetrain_id_index ON vehicle_offers (drivetrain_id);
CREATE INDEX vehicle_offers_body_style_id_index ON vehicle_offers (body_style_id);
CREATE INDEX vehicle_offers_fuel_type_id_index ON vehicle_offers (fuel_type_id);
CREATE INDEX vehicle_offers_transmission_id_index ON vehicle_offers (transmission_id);
CREATE INDEX vehicle_offers_franchise_id_index ON vehicle_offers (franchise_id);
CREATE INDEX vehicle_offers_type_id_index ON vehicle_offers (type_id);
CREATE INDEX vehicle_offers_type_index ON vehicle_offers (type);
CREATE INDEX vehicle_offers_published_index ON vehicle_offers (published);
CREATE INDEX vehicle_offers_published_at_index ON vehicle_offers (published_at);
CREATE INDEX vehicle_offers_form_id_index ON vehicle_offers (form_id);
CREATE INDEX vehicle_offers_model_id_index ON vehicle_offers (model_id);
CREATE INDEX vehicle_offers_make_id_index ON vehicle_offers (make_id);
CREATE INDEX vehicle_offers_dealership_id_index ON vehicle_offers (dealership_id);
CREATE INDEX vehicle_offers_template_id_index ON vehicle_offers (template_id);
CREATE INDEX vehicle_offers_featured_index ON vehicle_offers (featured);
CREATE INDEX vehicle_offers_status_index ON vehicle_offers (status);
CREATE INDEX vehicle_offers_slug_index ON vehicle_offers (slug);
CREATE INDEX "media_source_filename_index" on "media" ("source_filename");
CREATE INDEX "vehicle_offer_price" on "vehicle_offers" ("price");
CREATE INDEX "vehicle_offers_battery_quick_charge_level_index" on "vehicle_offers" ("battery_quick_charge_level");
CREATE INDEX "vehicles_battery_quick_charge_level_index" on "vehicles" ("battery_quick_charge_level");
CREATE INDEX "enquiry_types_template_name_index" on "enquiry_types" ("template_name");
CREATE INDEX "vehicles_vehicle_length_index" on "vehicles" ("vehicle_length");
CREATE INDEX "body_styles_has_subcategories_index" on "body_styles" ("has_subcategories");
CREATE INDEX "service_location_availability_email_index" on "service_location_availability" ("email");
CREATE INDEX "vfinance_provider" on "vehicle_finance" ("provider");
CREATE INDEX "vfinance_type" on "vehicle_finance" ("finance_type");
CREATE INDEX "vfinance_price" on "vehicle_finance" ("monthly_price");
CREATE INDEX "vav_slug" on "vehicle_attribute_values" ("slug");
CREATE INDEX "valuations_valuation_id_index" on "valuations" ("valuation_id");
CREATE INDEX "vehicles_vrm_condensed_index" on "vehicles" ("vrm_condensed");
CREATE TABLE seo_data (id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, path VARCHAR(255) NOT NULL, title VARCHAR(255) DEFAULT NULL, description VARCHAR(500) DEFAULT NULL, heading VARCHAR(255) DEFAULT NULL, created_at DATETIME DEFAULT NULL, updated_at DATETIME DEFAULT NULL, content_element_id INTEGER DEFAULT NULL, content CLOB DEFAULT NULL, content_description CLOB DEFAULT NULL, json_schema CLOB DEFAULT NULL);
CREATE INDEX seo_data_content_element_id_index ON seo_data (content_element_id);
CREATE UNIQUE INDEX seo_data_path_unique ON seo_data (path);
CREATE TABLE IF NOT EXISTS "import_maps" ("id" integer primary key autoincrement not null, "name" varchar not null, "slug" varchar not null, "type" varchar not null, "data" text, "created_at" datetime, "updated_at" datetime);
CREATE INDEX "import_maps_slug_index" on "import_maps" ("slug");
CREATE INDEX "import_maps_type_index" on "import_maps" ("type");
CREATE TABLE IF NOT EXISTS "import_map_fields" ("id" integer primary key autoincrement not null, "map_id" integer not null, "on_file" varchar not null, "on_model" varchar, "default_value" varchar, "is_list" tinyint(1) not null default '0', "is_images" tinyint(1) not null default '0', "list_separator" varchar, "data" varchar, "created_at" datetime, "updated_at" datetime);
CREATE INDEX "import_map_fields_map_id_index" on "import_map_fields" ("map_id");
CREATE TABLE IF NOT EXISTS "new_car_fuel_types" ("id" integer primary key autoincrement not null, "new_car_id" integer not null, "fuel_type_id" integer not null, "created_at" datetime, "updated_at" datetime);
CREATE INDEX "new_car_fuel_types_new_car_id_index" on "new_car_fuel_types" ("new_car_id");
CREATE INDEX "new_car_fuel_types_fuel_type_id_index" on "new_car_fuel_types" ("fuel_type_id");
CREATE TABLE new_cars (id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, name VARCHAR(255) NOT NULL COLLATE "BINARY", slug VARCHAR(255) DEFAULT NULL COLLATE "BINARY", status VARCHAR(255) DEFAULT NULL COLLATE "BINARY", featured BOOLEAN DEFAULT 0 NOT NULL, published BOOLEAN DEFAULT 0 NOT NULL, type VARCHAR(255) DEFAULT NULL COLLATE "BINARY", derivative VARCHAR(255) DEFAULT NULL COLLATE "BINARY", template_id INTEGER DEFAULT NULL, dealership_id INTEGER DEFAULT NULL, make_id INTEGER DEFAULT NULL, model_id INTEGER DEFAULT NULL, form_id INTEGER DEFAULT NULL, price NUMERIC(10, 0) DEFAULT NULL, deposit NUMERIC(10, 0) DEFAULT NULL, published_at DATETIME DEFAULT NULL, seo CLOB DEFAULT NULL COLLATE "BINARY", data CLOB DEFAULT NULL COLLATE "BINARY", search_content CLOB DEFAULT NULL COLLATE "BINARY", transmission_id INTEGER DEFAULT NULL, body_style_id INTEGER DEFAULT NULL, drivetrain_id INTEGER DEFAULT NULL, engine_size_cc INTEGER DEFAULT NULL, colour VARCHAR(255) DEFAULT NULL COLLATE "BINARY", franchise_id INTEGER DEFAULT NULL, type_id INTEGER DEFAULT NULL, created_at DATETIME DEFAULT NULL, updated_at DATETIME DEFAULT NULL, deleted_at DATETIME DEFAULT NULL, excerpt VARCHAR(255) DEFAULT NULL COLLATE "BINARY");
CREATE INDEX new_cars_deleted_at_idx ON new_cars (deleted_at);
CREATE INDEX new_cars_type_id_index ON new_cars (type_id);
CREATE INDEX new_cars_franchise_id_index ON new_cars (franchise_id);
CREATE INDEX new_cars_colour_index ON new_cars (colour);
CREATE INDEX new_cars_engine_size_cc_index ON new_cars (engine_size_cc);
CREATE INDEX new_cars_drivetrain_id_index ON new_cars (drivetrain_id);
CREATE INDEX new_cars_body_style_id_index ON new_cars (body_style_id);
CREATE INDEX new_cars_transmission_id_index ON new_cars (transmission_id);
CREATE INDEX new_cars_published_at_index ON new_cars (published_at);
CREATE INDEX new_cars_form_id_index ON new_cars (form_id);
CREATE INDEX new_cars_model_id_index ON new_cars (model_id);
CREATE INDEX new_cars_make_id_index ON new_cars (make_id);
CREATE INDEX new_cars_dealership_id_index ON new_cars (dealership_id);
CREATE INDEX new_cars_template_id_index ON new_cars (template_id);
CREATE INDEX new_cars_type_index ON new_cars (type);
CREATE INDEX new_cars_published_index ON new_cars (published);
CREATE INDEX new_cars_featured_index ON new_cars (featured);
CREATE INDEX new_cars_status_index ON new_cars (status);
CREATE INDEX new_cars_slug_index ON new_cars (slug);
CREATE INDEX "offer_types_parent_id_index" on "offer_types" ("parent_id");
CREATE INDEX "reservations_attempts_index" on "reservations" ("attempts");
CREATE INDEX "vehicle_makes_cap_id_index" on "vehicle_makes" ("cap_id");
CREATE INDEX "vehicle_makes_lcv_cap_id_index" on "vehicle_makes" ("lcv_cap_id");
CREATE INDEX "vehicle_models_lcv_cap_id_index" on "vehicle_models" ("lcv_cap_id");
CREATE INDEX "vehicle_offers_auto_trader_id_index" on "vehicle_offers" ("auto_trader_id");
CREATE INDEX "vehicle_offers_cap_id_index" on "vehicle_offers" ("cap_id");
INSERT INTO migrations VALUES(1,'2016_10_10_161101_create_media_table',1);
INSERT INTO migrations VALUES(2,'2020_10_26_114600_create_page_tables',1);
INSERT INTO migrations VALUES(3,'2020_10_28_150227_create_notification_table',1);
INSERT INTO migrations VALUES(4,'2020_11_11_120601_create_enquiry_table',1);
INSERT INTO migrations VALUES(5,'2020_11_11_120601_create_forms_tables',1);
INSERT INTO migrations VALUES(6,'2021_06_04_113247_create_pinned_items_table',1);
INSERT INTO migrations VALUES(7,'2021_11_09_091647_create_settings_table',1);
INSERT INTO migrations VALUES(8,'2021_11_17_075514_create_filter_index_table',1);
INSERT INTO migrations VALUES(9,'2022_01_21_124819_create_vehicle_tables',1);
INSERT INTO migrations VALUES(10,'2022_01_25_091629_create_tenant_vehicle_taxonomy_tables',1);
INSERT INTO migrations VALUES(11,'2022_02_24_091205_create_dealerships_table',1);
INSERT INTO migrations VALUES(12,'2022_03_02_120554_create_vehicle_offers_table',1);
INSERT INTO migrations VALUES(13,'2022_03_15_141524_create_reporting_stats_table',1);
INSERT INTO migrations VALUES(14,'2022_03_31_091212_create_vehicle_tech_data_table',1);
INSERT INTO migrations VALUES(15,'2022_04_08_110350_create_sales_channel_history_table',1);
INSERT INTO migrations VALUES(16,'2022_06_03_143737_create_seo_defaults_table',1);
INSERT INTO migrations VALUES(17,'2022_06_13_074517_create_report_table',1);
INSERT INTO migrations VALUES(18,'2022_08_30_081134_add_linked_model_to_menu_entries',1);
INSERT INTO migrations VALUES(19,'2022_09_08_135139_add_demo_reserved_to_vehicles',1);
INSERT INTO migrations VALUES(20,'2022_09_09_101256_add_categories_to_pages',1);
INSERT INTO migrations VALUES(21,'2022_09_09_144744_create_seeds_table',1);
INSERT INTO migrations VALUES(22,'2022_09_12_074504_add_export_time_settings_to_reports',1);
INSERT INTO migrations VALUES(23,'2022_09_14_133624_add_columns_to_vehicle_offers',1);
INSERT INTO migrations VALUES(24,'2022_09_16_082741_add_verify_fields_to_settings',1);
INSERT INTO migrations VALUES(25,'2022_09_22_111319_create_seo_redirects_table',1);
INSERT INTO migrations VALUES(26,'2022_09_28_131013_create_franchises_table',1);
INSERT INTO migrations VALUES(27,'2022_10_06_141514_create_valuations_table',1);
INSERT INTO migrations VALUES(28,'2022_10_14_085747_add_types_to_offers',1);
INSERT INTO migrations VALUES(29,'2022_10_17_141914_add_data_ordering_to_page_content',1);
INSERT INTO migrations VALUES(30,'2022_10_19_133133_add_provider_to_vehicles',1);
INSERT INTO migrations VALUES(31,'2022_10_20_121843_create_vehicle_offer_content_history_table',1);
INSERT INTO migrations VALUES(32,'2022_10_21_072203_create_offer_types_table',1);
INSERT INTO migrations VALUES(33,'2022_10_21_121410_create_offer_finance_table',1);
INSERT INTO migrations VALUES(34,'2022_10_24_091902_create_dealership_holidays_table',1);
INSERT INTO migrations VALUES(35,'2022_10_24_125530_add_uuid_to_page_versions',1);
INSERT INTO migrations VALUES(36,'2022_10_28_083614_add_ui_fields_to_elements',1);
INSERT INTO migrations VALUES(37,'2022_10_31_144104_add_template_element_id_to_page_content',1);
INSERT INTO migrations VALUES(38,'2022_11_04_140830_add_ev_fields_to_vehicles',1);
INSERT INTO migrations VALUES(39,'2022_11_14_091928_add_slug_to_content_fields',1);
INSERT INTO migrations VALUES(40,'2022_11_15_085555_create_vehicle_features_table',1);
INSERT INTO migrations VALUES(41,'2022_11_17_115734_add_field_data_to_template_elements',1);
INSERT INTO migrations VALUES(42,'2022_11_21_092545_add_drag_and_drop_to_content_elements',1);
INSERT INTO migrations VALUES(43,'2022_11_22_125744_add_additional_price_fields_to_vehicles',1);
INSERT INTO migrations VALUES(44,'2022_12_02_143727_add_colours_to_franchises',1);
INSERT INTO migrations VALUES(45,'2022_12_20_132238_create_vehicle_offer_views_tables',1);
INSERT INTO migrations VALUES(46,'2023_01_23_081410_create_vehicle_autotrader_data',1);
INSERT INTO migrations VALUES(47,'2023_01_27_100934_add_pending_review_to_page_versions',1);
INSERT INTO migrations VALUES(48,'2023_02_01_142956_create_properties_table',1);
INSERT INTO migrations VALUES(49,'2023_02_07_140802_add_template_element_id_to_vehicle_offer_content',1);
INSERT INTO migrations VALUES(50,'2023_02_09_142105_add_version_content_table',1);
INSERT INTO migrations VALUES(51,'2023_02_10_080304_add_og_image_to_seo_defaults',1);
INSERT INTO migrations VALUES(52,'2023_02_13_092820_add_franchise_id_to_vehicle_offers',1);
INSERT INTO migrations VALUES(53,'2023_02_14_125756_drop_form_actions',1);
INSERT INTO migrations VALUES(54,'2023_02_17_082258_add_slug_to_vehicle_offer_content',1);
INSERT INTO migrations VALUES(55,'2023_03_07_115807_add_external_to_media',1);
INSERT INTO migrations VALUES(56,'2023_03_07_145027_add_meta_to_template_elements',1);
INSERT INTO migrations VALUES(57,'2023_03_09_125714_create_vehicle_labels_table',1);
INSERT INTO migrations VALUES(58,'2023_03_09_125847_add_video_to_vehicles',1);
INSERT INTO migrations VALUES(59,'2023_03_14_084017_add_meta_to_menus',1);
INSERT INTO migrations VALUES(60,'2023_03_20_135254_add_vehicle_id_to_vehicle_features',1);
INSERT INTO migrations VALUES(61,'2023_04_19_072036_add_superadmin_to_settings',1);
INSERT INTO migrations VALUES(62,'2023_05_03_090656_add_valuation_id_to_enquiries',1);
INSERT INTO migrations VALUES(63,'2023_05_12_132621_add_colors_to_vehicle_makes',1);
INSERT INTO migrations VALUES(64,'2023_05_16_093901_add_timezone_to_dealerships',1);
INSERT INTO migrations VALUES(65,'2023_05_19_073351_add_details_to_vehicle_offers',1);
INSERT INTO migrations VALUES(66,'2023_05_24_082957_create_audits_table',1);
INSERT INTO migrations VALUES(67,'2023_06_08_072025_create_conversions_table',1);
INSERT INTO migrations VALUES(68,'2023_06_12_085844_add_last_used_to_media',1);
INSERT INTO migrations VALUES(69,'2023_06_14_112209_add_interior_exterior_flags_to_media_uses',1);
INSERT INTO migrations VALUES(70,'2023_06_14_140325_add_unique_to_media',1);
INSERT INTO migrations VALUES(71,'2023_06_15_075821_create_colour_maps_table',1);
INSERT INTO migrations VALUES(72,'2023_06_19_080924_add_monthly_cost_type_to_vehicles',1);
INSERT INTO migrations VALUES(73,'2023_06_27_125041_make_vehicle_id_unique_for_autotrader_data',1);
INSERT INTO migrations VALUES(74,'2023_06_28_115448_extend_hex_code_length_to_colours',1);
INSERT INTO migrations VALUES(75,'2023_06_28_133505_create_vehicle_eav_tables',1);
INSERT INTO migrations VALUES(76,'2023_06_30_072757_add_quick_view_hits_to_vehicle_views',1);
INSERT INTO migrations VALUES(77,'2023_06_30_082921_create_new_cars_table',1);
INSERT INTO migrations VALUES(78,'2023_07_05_124819_nullable_vehicle_finance',1);
INSERT INTO migrations VALUES(79,'2023_07_10_075352_unify_vehicle_offer_fiance_table_column_names',1);
INSERT INTO migrations VALUES(80,'2023_07_11_124046_add_archive_flag_to_vehicles',1);
INSERT INTO migrations VALUES(81,'2023_07_17_082149_update_vehicle_type_from_valuations_table',1);
INSERT INTO migrations VALUES(82,'2023_07_17_140954_create_property_attribute_values_table',1);
INSERT INTO migrations VALUES(83,'2023_07_24_134716_create_valuation_adjustments_table',1);
INSERT INTO migrations VALUES(84,'2023_07_26_081545_add_vat_applicable_to_vehicles',1);
INSERT INTO migrations VALUES(85,'2023_07_31_150400_update_vehicle_attribute_values',1);
INSERT INTO migrations VALUES(86,'2023_08_02_073950_add_vehicle_id_to_sales_channel_history',1);
INSERT INTO migrations VALUES(87,'2023_08_08_074744_add_model_to_media_sizes',1);
INSERT INTO migrations VALUES(88,'2023_08_16_121037_add_active_to_dealerships',1);
INSERT INTO migrations VALUES(89,'2023_08_22_125006_add_css_and_external_to_menu_entries',1);
INSERT INTO migrations VALUES(90,'2023_09_01_073411_fix_media_tags_column',1);
INSERT INTO migrations VALUES(91,'2023_09_12_090350_add_was_recently_synced_to_vehicles',1);
INSERT INTO migrations VALUES(92,'2023_09_13_095500_add_lcv_columns_to_vehicles_table',1);
INSERT INTO migrations VALUES(93,'2023_09_15_131040_index_soft_delete_columns',1);
INSERT INTO migrations VALUES(94,'2023_09_18_091600_add_unique_indexes_to_vehicle_data_tables',1);
INSERT INTO migrations VALUES(95,'2023_09_18_092021_add_feature_flag_to_settings',1);
INSERT INTO migrations VALUES(96,'2023_09_18_141400_add_previous_price_to_vehicles_table',1);
INSERT INTO migrations VALUES(97,'2023_09_21_073112_create_api_notifications_table',1);
INSERT INTO migrations VALUES(98,'2023_09_21_082149_add_colour_to_valuations_table',1);
INSERT INTO migrations VALUES(99,'2023_09_22_134916_add_created_at_index_to_vehicles',1);
INSERT INTO migrations VALUES(100,'2023_09_27_110300_update_vehicle_price_storage',1);
INSERT INTO migrations VALUES(101,'2023_09_27_150300_add_franchise_to_dealerships_table',1);
INSERT INTO migrations VALUES(102,'2023_10_03_072102_add_franchise_to_pages_menus',1);
INSERT INTO migrations VALUES(103,'2023_10_05_114930_add_content_fields_to_seo_data',1);
INSERT INTO migrations VALUES(104,'2023_10_10_1158_creat_label_rules_table',1);
INSERT INTO migrations VALUES(105,'2023_10_12_130633_add_notes_to_dealerships',1);
INSERT INTO migrations VALUES(106,'2023_10_18_112848_add_skoda_fields',1);
INSERT INTO migrations VALUES(107,'2023_10_22_061928_add_pending_sync_to_vehicles',1);
INSERT INTO migrations VALUES(108,'2023_10_22_072411_add_attention_grabber_to_vehicles',1);
INSERT INTO migrations VALUES(109,'2023_10_24_130809_add_exceprt_to_pages',1);
INSERT INTO migrations VALUES(110,'2023_10_26_085353_vehicle_attribute_value_unique_index',1);
INSERT INTO migrations VALUES(111,'2023_10_26_135417_create_content_categories_tags_tables',1);
INSERT INTO migrations VALUES(112,'2023_11_03_075248_add_content_description_to_seo_data',1);
INSERT INTO migrations VALUES(113,'2023_11_09_123530_add_coords_fields_to_vehicles',1);
INSERT INTO migrations VALUES(114,'2023_11_12_052266_change_description_length_for_vehicle_standard_data',1);
INSERT INTO migrations VALUES(115,'2023_11_12_053658_change_value_length_for_vehicle_tech_data',1);
INSERT INTO migrations VALUES(116,'2023_11_16_084208_create_service_booking_tables',1);
INSERT INTO migrations VALUES(117,'2023_12_06_143200_add_additional_vehicle_finance_columns',1);
INSERT INTO migrations VALUES(118,'2023_12_07_152400_add_vehicle_label_content',1);
INSERT INTO migrations VALUES(119,'2023_12_14_092906_add_hidden_to_page_content',1);
INSERT INTO migrations VALUES(120,'2023_12_15_091600_add_index_to_media',1);
INSERT INTO migrations VALUES(121,'2023_12_15_143700_add_defaults_to_content_tables',1);
INSERT INTO migrations VALUES(122,'2023_12_19_125659_create_search_index_table',1);
INSERT INTO migrations VALUES(123,'2023_12_29_065645_create_service_location_availability_table',1);
INSERT INTO migrations VALUES(124,'2024_01_15_094651_add_compare_views_to_vehicle_views_table',1);
INSERT INTO migrations VALUES(125,'2024_01_16_084605_add_start_end_time_to_global_content_table',1);
INSERT INTO migrations VALUES(126,'2024_01_16_115149_adjust_decimals_to_vehicle_finance',1);
INSERT INTO migrations VALUES(127,'2024_01_19_151140_add_segment_to_form_questions',1);
INSERT INTO migrations VALUES(128,'2024_01_22_090002_add_segments_to_form_sections',1);
INSERT INTO migrations VALUES(129,'2024_01_22_123530_create_replacements_table',1);
INSERT INTO migrations VALUES(130,'2024_01_26_095706_add_confirmation_sent_to_enquiries',1);
INSERT INTO migrations VALUES(131,'2024_01_26_131424_remove_filter_index_unique_slug_constraint',1);
INSERT INTO migrations VALUES(132,'2024_01_29_085333_create_media_folders_table',1);
INSERT INTO migrations VALUES(133,'2024_02_01_134851_add_password_protection_to_pages',1);
INSERT INTO migrations VALUES(134,'2024_02_05_094900_add_lat_lng_to_dealerships',1);
INSERT INTO migrations VALUES(135,'2024_02_06_132644_add_order_to_media_folders_table',1);
INSERT INTO migrations VALUES(136,'2024_02_09_093034_add_trim_to_vehicles',1);
INSERT INTO migrations VALUES(137,'2024_02_12_133839_add_ingested_at_to_service_bookings_table',1);
INSERT INTO migrations VALUES(138,'2024_02_14_092229_add_admin_fee_to_vehicles',1);
INSERT INTO migrations VALUES(139,'2024_02_15_105800_create_catalog_offers_table',1);
INSERT INTO migrations VALUES(140,'2024_02_19_080308_add_featured_to_pages',1);
INSERT INTO migrations VALUES(141,'2024_02_29_092404_add_value_text_to_settings_table',1);
INSERT INTO migrations VALUES(142,'2024_03_01_073604_add_from_to_restrictions_to_service_availability',1);
INSERT INTO migrations VALUES(143,'2024_03_07_172000_add_franchise_to_labels',1);
INSERT INTO migrations VALUES(144,'2024_03_11_114700_add_attempts_to_enquiry_actions_table',1);
INSERT INTO migrations VALUES(145,'2024_03_13_083841_create_reservations_table',1);
INSERT INTO migrations VALUES(146,'2024_03_13_135602_create_invoice_tables',1);
INSERT INTO migrations VALUES(147,'2024_03_18_142818_add_json_schema_to_seo_data',1);
INSERT INTO migrations VALUES(148,'2024_03_20_095100_add_columns_to_vehicle_offers',1);
INSERT INTO migrations VALUES(149,'2024_03_22_100047_add_adjusted_fields_to_valuations_table',1);
INSERT INTO migrations VALUES(150,'2024_03_27_070823_add_preview_image_to_content_elements',1);
INSERT INTO migrations VALUES(151,'2024_03_28_073603_add_active_to_labels',1);
INSERT INTO migrations VALUES(152,'2024_04_04_150200_index_vehicle_trim',1);
INSERT INTO migrations VALUES(153,'2024_04_04_164700_create_trims_table',1);
INSERT INTO migrations VALUES(154,'2024_04_14_202839_add_excerpt_to_new_cars_table',1);
INSERT INTO migrations VALUES(155,'2024_04_14_203006_add_label_excerpt_to_vehicle_offers_table',1);
INSERT INTO migrations VALUES(156,'2024_04_24_212723_add_invested_at_to_reservations_table',1);
INSERT INTO migrations VALUES(157,'2024_04_26_160145_add_fields_to_invoices_tables',1);
INSERT INTO migrations VALUES(158,'2024_04_28_204946_create_reservation_statuses_table',1);
INSERT INTO migrations VALUES(159,'2024_05_03_145100_update_vehicle_trims',1);
INSERT INTO migrations VALUES(160,'2024_05_07_131217_add_cta_buttons_to_vehicle_offers_table',1);
INSERT INTO migrations VALUES(161,'2024_05_07_152101_add_external_showroom_url_to_dealerships_table',1);
INSERT INTO migrations VALUES(162,'2024_05_08_115155_add_content_to_dealerships',1);
INSERT INTO migrations VALUES(163,'2024_05_09_110837_add_second_alt_open_times_to_dealerships_table',1);
INSERT INTO migrations VALUES(164,'2024_05_09_120138_change_excerpt_type_in_vehicle_offers_table',1);
INSERT INTO migrations VALUES(165,'2024_05_15_150127_fix_value_text_not_fillable_to_settings',1);
INSERT INTO migrations VALUES(166,'2024_05_17_135300_ensure_offer_finance_has_term',1);
INSERT INTO migrations VALUES(167,'2024_05_21_115400_add_co2_to_vehicle_offers',1);
INSERT INTO migrations VALUES(168,'2024_05_29_071206_add_original_path_to_media',1);
INSERT INTO migrations VALUES(169,'2024_05_31_000000_index_vehicle_offers_price_column',1);
INSERT INTO migrations VALUES(170,'2024_05_31_144021_add_battery_quick_charge_level_to_vehicle_offers',1);
INSERT INTO migrations VALUES(171,'2024_06_02_125153_add_source_to_enquiries_table',1);
INSERT INTO migrations VALUES(172,'2024_06_05_111622_add_template_name_to_enquiry_types',1);
INSERT INTO migrations VALUES(173,'2024_06_07_113237_add_subcategory_splits_to_body_styles',1);
INSERT INTO migrations VALUES(174,'2024_06_07_161700_add_terms_to_vehicle_finance_table',1);
INSERT INTO migrations VALUES(175,'2024_06_14_120126_add_email_to_service_booking_availability',1);
INSERT INTO migrations VALUES(176,'2024_06_19_114922_add_indices_to_vehicle_finance',1);
INSERT INTO migrations VALUES(177,'2024_06_24_114500_add_valuation_id_to_valuations_table',1);
INSERT INTO migrations VALUES(178,'2024_06_27_145211_add_vrm_condensed_to_vehicles',1);
INSERT INTO migrations VALUES(179,'2024_07_02_170647_change_description_in_seo_data_table',1);
INSERT INTO migrations VALUES(180,'2024_07_09_080121_add_order_to_properties',1);
INSERT INTO migrations VALUES(181,'2024_07_12_120702_create_import_maps_table',1);
INSERT INTO migrations VALUES(182,'2024_07_18_165512_create_new_car_fuel_type_table',1);
INSERT INTO migrations VALUES(183,'2024_07_23_124455_add_send_customer_confirmation_email_to_forms',1);
INSERT INTO migrations VALUES(184,'2024_07_24_072041_add_domain_name_to_seo_redirects',1);
INSERT INTO migrations VALUES(185,'2024_07_24_113351_add_parent_id_to_offer_types',1);
INSERT INTO migrations VALUES(186,'2024_07_24_141612_add_soft_deletes_to_form_questions',1);
INSERT INTO migrations VALUES(187,'2024_07_25_120644_add_attempts_to_reservations',1);
INSERT INTO migrations VALUES(188,'2024_08_13_111032_add_cap_data_to_vehicle_makes_and_vehicle_models',1);
INSERT INTO migrations VALUES(189,'2024_08_16_094332_make_body_type_optional_fields_nullable',1);
INSERT INTO migrations VALUES(190,'2024_08_28_073609_add_description_to_trims',1);
INSERT INTO migrations VALUES(191,'2024_09_03_185533_add_cap_id_autotrader_id_to_vehicle_offers_table',1);
CREATE TABLE IF NOT EXISTS "users" ("id" integer primary key autoincrement not null, "name" varchar,  "email" varchar);
