<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Mtc\MercuryDataModels\Factories\VehicleValuationFactory;

class VehicleValuation extends \Mtc\VehicleValuation\Models\VehicleValuation
{
    use HasFactory;

    protected static function newFactory()
    {
        return VehicleValuationFactory::new();
    }

    public function enquiry(): HasOne
    {
        return $this->hasOne(Enquiry::class, 'valuation_id');
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function adjustment(): BelongsTo
    {
        return $this->belongsTo(ValuationAdjustment::class);
    }

    public function adjust(ValuationAdjustment $valuationAdjustment)
    {
        $this->adjustment_id = $valuationAdjustment->id;
        $this->adjusted_retail_price = $this->adjustPrice($this->retail_price, $valuationAdjustment);
        $this->adjusted_average_price = $this->adjustPrice($this->average_price, $valuationAdjustment);
        $this->adjusted_clean_price = $this->adjustPrice($this->clean_price, $valuationAdjustment);
        $this->adjusted_below_price = $this->adjustPrice($this->below_price, $valuationAdjustment);
        $this->save();
    }

    private function adjustPrice($price, ValuationAdjustment $valuationAdjustment)
    {
        if (empty($price)) {
            return null;
        }

        if ($valuationAdjustment->adjustment_type == 'amount') {
            $adjustmentAmount = $valuationAdjustment->is_increase
                ? $valuationAdjustment->adjustment_amount
                : -$valuationAdjustment->adjustment_amount;
            $price += $adjustmentAmount;
        } else {
            // Apply percentage adjustment
            $adjustmentMultiplier = $valuationAdjustment->is_increase
                ? (1 + ($valuationAdjustment->adjustment_amount / 100))
                : (1 - ($valuationAdjustment->adjustment_amount / 100));
            $price *= round($adjustmentMultiplier, 2);
        }

        return $price;
    }
}
