<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class VehicleOfferFinance extends Model
{
    protected $table = 'vehicle_offer_finance';

    protected $fillable = [
        'offer_id',
        'provider',
        'final_payment',
        'full_price',
        'deposit',
        'total_amount',
        'total_credit_amount',
        'apr',
        'interest_rate',
        'data',
        'finance_type',
        'term',
        'number_of_payments',
        'documentation_fee',
        'monthly_price',
        'first_payment',
        'annual_mileage',
        'customer_deposit',
        'dealer_deposit_contribution',
        'option_to_purchase_fee',
        'excess_mileage_charge',
    ];

    protected $casts = [
        'data' => 'array',
    ];

    public function offer(): BelongsTo
    {
        return $this->belongsTo(VehicleOffer::class, 'offer_id');
    }
}
