<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Support\Collection;
use Mtc\MercuryDataModels\Factories\VehicleAutoTraderDataFactory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class VehicleAutoTraderData extends Model
{
    use HasFactory;

    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'vehicle_autotrader_data';

    /**
     * Mass assign attributes
     *
     * @var string[]
     */
    protected $fillable = [
        'vehicle_id',
        'valuation',
        'price_point',
        'price_position',
        'search_results_7d',
        'ad_views',
        'ad_views_7d',
        'performance_rating',
        'lead_count_rating',
        'publish_advert',
        'publish_profile',
        'advert_publish_state',
        'profile_publish_state',
        'lifecycle_state',
        'derivative_id',
        'at_export_error',
    ];

    /**
     * Model factory
     *
     * @return VehicleAutoTraderDataFactory
     */
    protected static function newFactory()
    {
        return VehicleAutoTraderDataFactory::new();
    }

    /**
     * Relationship with Vehicle
     *
     * @return BelongsTo
     */
    public function vehicle(): BelongsTo
    {
        return $this->belongsTo(Vehicle::class, 'vehicle_id');
    }

    public function getDisplayAttributes(): Collection
    {
        return collect($this->getAttributes())
            ->filter(fn ($attribute, $key) => $this->isFillable($key) && $key !== 'vehicle_id');
    }
}
