<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Mtc\MercuryDataModels\Factories\ValuationAdjustmentRuleFactory;

class ValuationAdjustmentRule extends Model
{
    use HasFactory;

    protected $table = 'valuation_adjustment_rules';

    protected $fillable = [
        'adjustment_id',
        'column',
        'operator',
        'value',
    ];


    protected static function newFactory()
    {
        return ValuationAdjustmentRuleFactory::new();
    }

    public function adjustment(): BelongsTo
    {
        return $this->belongsTo(ValuationAdjustment::class, 'adjustment_id');
    }
}
