<?php

namespace Mtc\MercuryDataModels\Traits;

use Illuminate\Database\Eloquent\Builder;

trait OrderByName
{
    /**
     * Set default order by to name column
     *
     * @return void
     */
    public static function bootOrderByName(): void
    {
        static::addGlobalScope(fn (Builder $query) => $query->orderBy('name'));
    }
}
