<?php

namespace Mtc\MercuryDataModels\Traits;

use Mtc\MercuryDataModels\Enums\SocialMediaPlatform;

trait HasSocials
{
    public function initializeHasSocials(): void
    {
        $this->mergeCasts(['socials' => 'array']);
        $this->fillable = array_merge($this->fillable, ['socials']);
    }

    public function ensureSocialsHasAllPlatforms(): void
    {
        $socials = $this->socials ?? [];
        foreach (SocialMediaPlatform::cases() as $platform) {
            if (!isset($socials[$platform->value])) {
                $socials[$platform->value] = null;
            }
        }
        $this->socials = $socials;
    }

    public function getFilteredSocials(): array
    {
        $allowedPlatforms = SocialMediaPlatform::values();

        return collect($this->socials ?? [])
            ->filter(fn ($url, $key) => !empty($url) && in_array($key, $allowedPlatforms))
            ->map(fn ($url, $key) => ['key' => $key, 'url' => $url])
            ->values()
            ->toArray();
    }
}
