<?php

namespace Mtc\MercuryDataModels\Traits;

use Illuminate\Support\Str;

trait EnsuresSlug
{
    private function ensureSlug()
    {
        if (empty($this->attributes['slug'])) {
            $slug = Str::slug($this->attributes['name']);
            $this->attributes['slug'] = $slug;

            $loop = 1;
            while (self::query()->where('slug', $this->slug)->exists()) {
                $this->attributes['slug'] = $slug . '-' . ($loop++);
            }
        }
    }

    /**
     * Accepts a string and returns a string which has not yet been used as a slug
     *
     * @param string $slug_in
     * @return string
     */
    public function ensureSlugFromString(string $slug_in): string
    {
        $slug = $slug_in;
        $loop = 1;

        while (self::query()->where('slug', $slug)->exists()) {
            $slug = $slug_in . '-' . ($loop++);
        }

        return $slug;
    }
}
