<?php

namespace Mtc\MercuryDataModels\Services;

use App\Facades\Settings;
use Mtc\MercuryDataModels\Contracts\FacilitatesReservations;
use Mtc\MercuryDataModels\Vehicle;

class KeyloopReservationHelper implements FacilitatesReservations
{
    /**
     * @param KeyloopApi $api
     */
    public function __construct(protected KeyloopApi $api)
    {
        //
    }

    /**
     * @param Vehicle $vehicle
     * @return bool
     */
    public function vehicleAvailableForReservation(Vehicle $vehicle): bool
    {
        $details = $this->api->getVehicleDetails($vehicle);
        $status = $details['status'] ?? null;

        if (
            empty($status)
            || $status == 'AVAILABLE'
        ) {
            return true;
        }

        if (Settings::get('keyloop-reservations-update-local-status')) {
            $this->updateVehicleStatus($vehicle, $status);
        }

        return false;
    }

    /**
     * @param Vehicle $vehicle
     * @return void
     */
    public function setReserved(Vehicle $vehicle): void
    {
        $this->api->setVehicleReserved($vehicle);
    }

    /**
     * Update the vehicle's availability status.
     * Expected $status values:
     *       AVAILABLE
     *       RESERVED
     *       SOLD
     *       UNAVAILABLE
     *
     * @param Vehicle $vehicle
     * @param string $status
     * @return void
     */
    protected function updateVehicleStatus(Vehicle $vehicle, string $status)
    {
        if ($status == 'RESERVED') {
            $vehicle->update([
                'is_reserved' => true,
            ]);
        }

        if ($status == 'SOLD') {
            $vehicle->update([
                'is_sold' => true,
            ]);
        }
    }
}
